package io.provista.datahub.transaction;

import io.provista.datahub.dimension.*;

public class Adeudo extends io.intino.alexandria.led.Transaction {
	public static final int SIZE = 34;

	public Adeudo() {
		super(defaultByteStore());
	}

	public Adeudo(io.intino.alexandria.led.buffers.store.ByteStore store) {
		super(store);
    }

	public int size() {
		return SIZE;
	}

	public java.util.Map<String, Object> values() {
		java.util.Map<String, Object> values = new java.util.LinkedHashMap<>();
		values.put("importe", importe());
		values.put("kwh", kwh());
		values.put("ocr", ocr());
		values.put("iva", iva());
		values.put("dap", dap());
		values.put("diasFacturados", diasFacturados());
		return values;
	}

	protected long id() {
		return ocr();
	}

	public long importe() {
		return bitBuffer.getAlignedLong(0);
	}

	public long kwh() {
		return bitBuffer.getAlignedLong(64);
	}

	public long ocr() {
		return bitBuffer.getAlignedLong(128);
	}

	public int iva() {
		return bitBuffer.getIntegerNBits(192, 32);
	}

	public int dap() {
		return bitBuffer.getIntegerNBits(224, 32);
	}

	public int diasFacturados() {
		return bitBuffer.getIntegerNBits(256, 16);
	}

	public Adeudo importe(long importe) {
		bitBuffer.setAlignedLong(0, importe);
		return this;
	}

	public Adeudo kwh(long kwh) {
		bitBuffer.setAlignedLong(64, kwh);
		return this;
	}

	public Adeudo ocr(long ocr) {
		bitBuffer.setAlignedLong(128, ocr);
		return this;
	}

	public Adeudo iva(int iva) {
		bitBuffer.setIntegerNBits(192, 32, iva);
		return this;
	}

	public Adeudo dap(int dap) {
		bitBuffer.setIntegerNBits(224, 32, dap);
		return this;
	}

	public Adeudo diasFacturados(int diasFacturados) {
		bitBuffer.setIntegerNBits(256, 16, diasFacturados);
		return this;
	}

	private static io.intino.alexandria.led.buffers.store.ByteStore defaultByteStore() {
		java.nio.ByteBuffer buffer = io.intino.alexandria.led.util.memory.MemoryUtils.allocBuffer((long) SIZE);
		io.intino.alexandria.led.util.memory.MemoryAddress address = io.intino.alexandria.led.util.memory.MemoryAddress.of(buffer);
		return new io.intino.alexandria.led.buffers.store.ByteBufferStore(buffer, address, 0, buffer.capacity());
	}
}