package io.provista.datahub.events.vinculacion;

public class VinculacionDenegada extends io.intino.alexandria.event.Event implements java.io.Serializable {


	public enum TipoSolicitud {
		Alta, Baja
	}


	public VinculacionDenegada() {
		super("VinculacionDenegada");
	}

	public VinculacionDenegada(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public VinculacionDenegada(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public VinculacionDenegada ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public VinculacionDenegada ss(String ss) {
		super.ss(ss);
		return this;
	}

	public java.util.List<Long> contratos() {
		return new java.util.ArrayList<Long>(message.contains("contratos") ? java.util.Arrays.asList(message.get("contratos").as(Long[].class)) : java.util.Collections.emptyList()) {
			@Override
			public boolean add(Long value) {
				super.add(value);
				message.append("contratos", value);
				return true;
			}

			@Override
			public void add(int index, Long element) {
				throw new UnsupportedOperationException();
			}

			@Override
			public boolean remove(Object value) {
				if (!(value instanceof Long)) return false;
				super.remove(value);
				message.remove("contratos", value);
				return true;
			}

			@Override
			public Long remove(int index) {
				Long type = get(index);
				remove(type);
				return type;
			}

			@Override
			public boolean removeIf(java.util.function.Predicate<? super Long> filter) {
				return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
			}

			@Override
			public boolean removeAll(java.util.Collection<?> c) {
				c.forEach(this::remove);
				return true;
			}

			@Override
			public boolean addAll(java.util.Collection<? extends Long> c) {
				c.forEach(this::add);
				return true;
			}

			@Override
			public boolean addAll(int index, java.util.Collection<? extends Long> c) {
				throw new UnsupportedOperationException();
			}

			public void clear() {
				super.clear();
				message.remove("contratos");
			}
		};
	}

	public String convenio() {
		return !message.contains("convenio") ? null : message.get("convenio").asString();
	}

	public String origen() {
		return !message.contains("origen") ? null : message.get("origen").asString();
	}

	public String token() {
		return !message.contains("token") ? null : message.get("token").asString();
	}

	public String autorizacion() {
		return !message.contains("autorizacion") ? null : message.get("autorizacion").asString();
	}

	public String referencia() {
		return !message.contains("referencia") ? null : message.get("referencia").asString();
	}

	public TipoSolicitud tipoSolicitud() {
		return !message.contains("tipoSolicitud") ? null : TipoSolicitud.valueOf(message.get("tipoSolicitud").asString());
	}

	public VinculacionDenegada contratos(java.util.List<Long> contratos) {
		this.message.remove("contratos");
		contratos.forEach(v -> this.message.append("contratos", v));
		return this;
	}

	public VinculacionDenegada convenio(String convenio) {
		if (convenio == null) this.message.remove("convenio");
		else this.message.set("convenio", convenio);
		return this;
	}

	public VinculacionDenegada origen(String origen) {
		if (origen == null) this.message.remove("origen");
		else this.message.set("origen", origen);
		return this;
	}

	public VinculacionDenegada token(String token) {
		if (token == null) this.message.remove("token");
		else this.message.set("token", token);
		return this;
	}

	public VinculacionDenegada autorizacion(String autorizacion) {
		if (autorizacion == null) this.message.remove("autorizacion");
		else this.message.set("autorizacion", autorizacion);
		return this;
	}

	public VinculacionDenegada referencia(String referencia) {
		if (referencia == null) this.message.remove("referencia");
		else this.message.set("referencia", referencia);
		return this;
	}

	public VinculacionDenegada tipoSolicitud(TipoSolicitud tipoSolicitud) {
		if (tipoSolicitud == null) this.message.remove("tipoSolicitud");
		else this.message.set("tipoSolicitud", tipoSolicitud.name());
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}