package io.provista.datahub.events.procurador;

public class RespuestaVinculacionRecurrenteDeContrato extends io.provista.datahub.events.procurador.Respuesta implements java.io.Serializable {


	public enum CodigoAcuse {
		Exito, NoExitoRpuInexistente, NoExitoServicioEnAutogestion, NoExitoEnOtroEsquemaDeCobranza, NoExitoStatusNoVigente, NoExitoMovimientoNoReconocido, NoExitoErrorEscritura
	}


	public RespuestaVinculacionRecurrenteDeContrato() {
		super(new io.intino.alexandria.event.Event("RespuestaVinculacionRecurrenteDeContrato"));
	}

	public RespuestaVinculacionRecurrenteDeContrato(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public RespuestaVinculacionRecurrenteDeContrato(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public RespuestaVinculacionRecurrenteDeContrato ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public RespuestaVinculacionRecurrenteDeContrato ss(String ss) {
		super.ss(ss);
		return this;
	}

	public Long rpu() {
		return message.get("rpu").asLong();
	}

	public Integer movimiento() {
		return message.get("movimiento").asInteger();
	}

	public String fechaPeticion() {
		return !message.contains("fechaPeticion") ? null : message.get("fechaPeticion").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public String tarifa() {
		return !message.contains("tarifa") ? null : message.get("tarifa").asString();
	}

	public String fechaActualizacion() {
		return !message.contains("fechaActualizacion") ? null : message.get("fechaActualizacion").asString();
	}

	public CodigoAcuse codigoAcuse() {
		return !message.contains("codigoAcuse") ? null : CodigoAcuse.valueOf(message.get("codigoAcuse").asString());
	}

	public RespuestaVinculacionRecurrenteDeContrato rpu(Long rpu) {
		if (rpu == null) this.message.remove("rpu");
		else this.message.set("rpu", rpu);
		return this;
	}

	public RespuestaVinculacionRecurrenteDeContrato movimiento(Integer movimiento) {
		this.message.set("movimiento", movimiento);
		return this;
	}

	public RespuestaVinculacionRecurrenteDeContrato fechaPeticion(String fechaPeticion) {
		if (fechaPeticion == null) this.message.remove("fechaPeticion");
		else this.message.set("fechaPeticion", fechaPeticion);
		return this;
	}

	public RespuestaVinculacionRecurrenteDeContrato cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public RespuestaVinculacionRecurrenteDeContrato tarifa(String tarifa) {
		if (tarifa == null) this.message.remove("tarifa");
		else this.message.set("tarifa", tarifa);
		return this;
	}

	public RespuestaVinculacionRecurrenteDeContrato fechaActualizacion(String fechaActualizacion) {
		if (fechaActualizacion == null) this.message.remove("fechaActualizacion");
		else this.message.set("fechaActualizacion", fechaActualizacion);
		return this;
	}

	public RespuestaVinculacionRecurrenteDeContrato codigoAcuse(CodigoAcuse codigoAcuse) {
		if (codigoAcuse == null) this.message.remove("codigoAcuse");
		else this.message.set("codigoAcuse", codigoAcuse.name());
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}