package io.provista.datahub.events.procurador;

public class RespuestaVinculacionDomiciliacionDeContrato extends io.provista.datahub.events.procurador.Respuesta implements java.io.Serializable {


	public enum Movimiento {
		Alta, Baja
	}

	public enum FrecuenciaFacturacion {
		Mensual, BimestralPar, BimestralNon, Tetramestral01, Tetramestral02, Tetramestral03, Tetramestral04, SoloTemporales, CicloEspeciales
	}

	public enum CodigoAcuse {
		Exito, NoExitoRpuInexistente, NoExitoStatusNoVigente, NoExitoServicioNoDomiciliablePorEstarEnOtroEsquemaDeFacturacion, NoExitoErrorEscritura
	}


	public RespuestaVinculacionDomiciliacionDeContrato() {
		super(new io.intino.alexandria.event.Event("RespuestaVinculacionDomiciliacionDeContrato"));
	}

	public RespuestaVinculacionDomiciliacionDeContrato(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public RespuestaVinculacionDomiciliacionDeContrato(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public RespuestaVinculacionDomiciliacionDeContrato ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public RespuestaVinculacionDomiciliacionDeContrato ss(String ss) {
		super.ss(ss);
		return this;
	}

	public Long rpu() {
		return message.get("rpu").asLong();
	}

	public Movimiento movimiento() {
		return !message.contains("movimiento") ? null : Movimiento.valueOf(message.get("movimiento").asString());
	}

	public String fechaPeticion() {
		return !message.contains("fechaPeticion") ? null : message.get("fechaPeticion").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public FrecuenciaFacturacion frecuenciaFacturacion() {
		return !message.contains("frecuenciaFacturacion") ? null : FrecuenciaFacturacion.valueOf(message.get("frecuenciaFacturacion").asString());
	}

	public String fechaActualizacion() {
		return !message.contains("fechaActualizacion") ? null : message.get("fechaActualizacion").asString();
	}

	public CodigoAcuse codigoAcuse() {
		return !message.contains("codigoAcuse") ? null : CodigoAcuse.valueOf(message.get("codigoAcuse").asString());
	}

	public RespuestaVinculacionDomiciliacionDeContrato rpu(Long rpu) {
		if (rpu == null) this.message.remove("rpu");
		else this.message.set("rpu", rpu);
		return this;
	}

	public RespuestaVinculacionDomiciliacionDeContrato movimiento(Movimiento movimiento) {
		if (movimiento == null) this.message.remove("movimiento");
		else this.message.set("movimiento", movimiento.name());
		return this;
	}

	public RespuestaVinculacionDomiciliacionDeContrato fechaPeticion(String fechaPeticion) {
		if (fechaPeticion == null) this.message.remove("fechaPeticion");
		else this.message.set("fechaPeticion", fechaPeticion);
		return this;
	}

	public RespuestaVinculacionDomiciliacionDeContrato cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public RespuestaVinculacionDomiciliacionDeContrato frecuenciaFacturacion(FrecuenciaFacturacion frecuenciaFacturacion) {
		if (frecuenciaFacturacion == null) this.message.remove("frecuenciaFacturacion");
		else this.message.set("frecuenciaFacturacion", frecuenciaFacturacion.name());
		return this;
	}

	public RespuestaVinculacionDomiciliacionDeContrato fechaActualizacion(String fechaActualizacion) {
		if (fechaActualizacion == null) this.message.remove("fechaActualizacion");
		else this.message.set("fechaActualizacion", fechaActualizacion);
		return this;
	}

	public RespuestaVinculacionDomiciliacionDeContrato codigoAcuse(CodigoAcuse codigoAcuse) {
		if (codigoAcuse == null) this.message.remove("codigoAcuse");
		else this.message.set("codigoAcuse", codigoAcuse.name());
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}