package io.provista.datahub.events.procurador;

public class RespuestaPago extends io.provista.datahub.events.procurador.Respuesta implements java.io.Serializable {


	public enum StatusPago {
		Pendiente, Pagado, PagadoContabilizado, Credito, CreditoContabilizado, PasoAVigente, PagoYaProcesado, PasoAVigenteAnteriormente, NoCoincideImporte, PosibleCredito, RpuInexistente, DescargadoPorLotes
	}

	public enum StatusRespuestaPagoSICOM {
		Correcto, ErrorAperturaFicheros, RpuInexistenteS2, NoRegraboCATAL9, RpuInexistenteS2A, NoActualizoCATAL2A, AdeudoInexistenteCATAL4, AgricolaConvenidoDC, ErrorActualizarCompromiso, ErrorActualizarAdeudo, RutaInexistenteS1, DomPagadoNoProcedeCredito, DomPagoDobleOtroMedio, DomNoCoincideConElTotal, LlaveInexistenteBITPY
	}


	public RespuestaPago() {
		super(new io.intino.alexandria.event.Event("RespuestaPago"));
	}

	public RespuestaPago(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public RespuestaPago(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public RespuestaPago ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public RespuestaPago ss(String ss) {
		super.ss(ss);
		return this;
	}

	public Long rpu() {
		return message.get("rpu").asLong();
	}

	public String fechaAdeudo() {
		return !message.contains("fechaAdeudo") ? null : message.get("fechaAdeudo").asString();
	}

	public Integer tipoAdeudo() {
		return message.get("tipoAdeudo").asInteger();
	}

	public StatusPago statusPago() {
		return !message.contains("statusPago") ? null : StatusPago.valueOf(message.get("statusPago").asString());
	}

	public Integer claveMedio() {
		return message.get("claveMedio").asInteger();
	}

	public Long importe() {
		return message.get("importe").asLong();
	}

	public String fechaPago() {
		return !message.contains("fechaPago") ? null : message.get("fechaPago").asString();
	}

	public Integer area() {
		return message.get("area").asInteger();
	}

	public StatusRespuestaPagoSICOM statusRespuestaPagoSICOM() {
		return !message.contains("statusRespuestaPagoSICOM") ? null : StatusRespuestaPagoSICOM.valueOf(message.get("statusRespuestaPagoSICOM").asString());
	}

	public RespuestaPago rpu(Long rpu) {
		if (rpu == null) this.message.remove("rpu");
		else this.message.set("rpu", rpu);
		return this;
	}

	public RespuestaPago fechaAdeudo(String fechaAdeudo) {
		if (fechaAdeudo == null) this.message.remove("fechaAdeudo");
		else this.message.set("fechaAdeudo", fechaAdeudo);
		return this;
	}

	public RespuestaPago tipoAdeudo(Integer tipoAdeudo) {
		this.message.set("tipoAdeudo", tipoAdeudo);
		return this;
	}

	public RespuestaPago statusPago(StatusPago statusPago) {
		if (statusPago == null) this.message.remove("statusPago");
		else this.message.set("statusPago", statusPago.name());
		return this;
	}

	public RespuestaPago claveMedio(Integer claveMedio) {
		this.message.set("claveMedio", claveMedio);
		return this;
	}

	public RespuestaPago importe(Long importe) {
		if (importe == null) this.message.remove("importe");
		else this.message.set("importe", importe);
		return this;
	}

	public RespuestaPago fechaPago(String fechaPago) {
		if (fechaPago == null) this.message.remove("fechaPago");
		else this.message.set("fechaPago", fechaPago);
		return this;
	}

	public RespuestaPago area(Integer area) {
		this.message.set("area", area);
		return this;
	}

	public RespuestaPago statusRespuestaPagoSICOM(StatusRespuestaPagoSICOM statusRespuestaPagoSICOM) {
		if (statusRespuestaPagoSICOM == null) this.message.remove("statusRespuestaPagoSICOM");
		else this.message.set("statusRespuestaPagoSICOM", statusRespuestaPagoSICOM.name());
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}