package io.provista.datahub.events.procurador;

public class RespuestaContracargoDeContrato extends io.provista.datahub.events.procurador.Respuesta implements java.io.Serializable {


	public enum Observaciones {
		Aplicado, NoAplicado, RpuNoEncontrado
	}


	public RespuestaContracargoDeContrato() {
		super(new io.intino.alexandria.event.Event("RespuestaContracargoDeContrato"));
	}

	public RespuestaContracargoDeContrato(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public RespuestaContracargoDeContrato(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public RespuestaContracargoDeContrato ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public RespuestaContracargoDeContrato ss(String ss) {
		super.ss(ss);
		return this;
	}

	public Long rpu() {
		return message.get("rpu").asLong();
	}

	public Long importe() {
		return message.get("importe").asLong();
	}

	public Observaciones observaciones() {
		return !message.contains("observaciones") ? null : Observaciones.valueOf(message.get("observaciones").asString());
	}

	public RespuestaContracargoDeContrato rpu(Long rpu) {
		if (rpu == null) this.message.remove("rpu");
		else this.message.set("rpu", rpu);
		return this;
	}

	public RespuestaContracargoDeContrato importe(Long importe) {
		if (importe == null) this.message.remove("importe");
		else this.message.set("importe", importe);
		return this;
	}

	public RespuestaContracargoDeContrato observaciones(Observaciones observaciones) {
		if (observaciones == null) this.message.remove("observaciones");
		else this.message.set("observaciones", observaciones.name());
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}