package io.provista.datahub.events.netmetering;

public class Expediente extends io.intino.alexandria.event.Event implements java.io.Serializable {
	public enum Split {
		D2 {
			public String qn() {
				return "D2";
			}
		}, DA {
			public String qn() {
				return "DA";
			}
		}, DB {
			public String qn() {
				return "DB";
			}
		}, DC {
			public String qn() {
				return "DC";
			}
		}, DD {
			public String qn() {
				return "DD";
			}
		}, DF {
			public String qn() {
				return "DF";
			}
		}, DG {
			public String qn() {
				return "DG";
			}
		}, DJ {
			public String qn() {
				return "DJ";
			}
		}, DK {
			public String qn() {
				return "DK";
			}
		}, DL {
			public String qn() {
				return "DL";
			}
		}, DM {
			public String qn() {
				return "DM";
			}
		}, DN {
			public String qn() {
				return "DN";
			}
		}, DP {
			public String qn() {
				return "DP";
			}
		}, DU {
			public String qn() {
				return "DU";
			}
		}, DV {
			public String qn() {
				return "DV";
			}
		}, DW {
			public String qn() {
				return "DW";
			}
		}, DX {
			public String qn() {
				return "DX";
			}
		};

		public abstract String qn();

		public static Split splitByQn(String qn) {
			return java.util.Arrays.stream(values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);
		}
	}

	public Expediente() {
		super("Expediente");
	}

	public Expediente(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Expediente(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Expediente ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Expediente ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String numeroCuenta() {
		return !message.contains("numeroCuenta") ? null : message.get("numeroCuenta").asString();
	}

	public String idServicio() {
		return !message.contains("idServicio") ? null : message.get("idServicio").asString();
	}

	public String periodo() {
		return !message.contains("periodo") ? null : message.get("periodo").asString();
	}

	public Integer remanente() {
		return message.get("remanente").asInteger();
	}

	public Integer precio() {
		return message.get("precio").asInteger();
	}

	public Long importe() {
		return message.get("importe").asLong();
	}

	public Expediente numeroCuenta(String numeroCuenta) {
		if (numeroCuenta == null) this.message.remove("numeroCuenta");
		else this.message.set("numeroCuenta", numeroCuenta);
		return this;
	}

	public Expediente idServicio(String idServicio) {
		if (idServicio == null) this.message.remove("idServicio");
		else this.message.set("idServicio", idServicio);
		return this;
	}

	public Expediente periodo(String periodo) {
		if (periodo == null) this.message.remove("periodo");
		else this.message.set("periodo", periodo);
		return this;
	}

	public Expediente remanente(Integer remanente) {
		this.message.set("remanente", remanente);
		return this;
	}

	public Expediente precio(Integer precio) {
		this.message.set("precio", precio);
		return this;
	}

	public Expediente importe(Long importe) {
		if (importe == null) this.message.remove("importe");
		else this.message.set("importe", importe);
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}