package io.provista.datahub.events.digestor;

public class Digestion extends io.intino.alexandria.event.Event implements java.io.Serializable {

	public Digestion() {
		super("Digestion");
	}

	public Digestion(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Digestion(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Digestion ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Digestion ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String goal() {
		return !message.contains("goal") ? null : message.get("goal").asString();
	}

	public String from() {
		return !message.contains("from") ? null : message.get("from").asString();
	}

	public String to() {
		return !message.contains("to") ? null : message.get("to").asString();
	}

	public String division() {
		return !message.contains("division") ? null : message.get("division").asString();
	}

	public String source() {
		return !message.contains("source") ? null : message.get("source").asString();
	}

	public String sourceTimetag() {
		return !message.contains("sourceTimetag") ? null : message.get("sourceTimetag").asString();
	}

	public Integer bulks() {
		return message.get("bulks").asInteger();
	}

	public Integer records() {
		return message.get("records").asInteger();
	}

	public Integer invalidRecords() {
		return message.get("invalidRecords").asInteger();
	}

	public Integer errors() {
		return message.get("errors").asInteger();
	}

	public Integer warnings() {
		return message.get("warnings").asInteger();
	}

	public Digestion goal(String goal) {
		if (goal == null) this.message.remove("goal");
		else this.message.set("goal", goal);
		return this;
	}

	public Digestion from(String from) {
		if (from == null) this.message.remove("from");
		else this.message.set("from", from);
		return this;
	}

	public Digestion to(String to) {
		if (to == null) this.message.remove("to");
		else this.message.set("to", to);
		return this;
	}

	public Digestion division(String division) {
		if (division == null) this.message.remove("division");
		else this.message.set("division", division);
		return this;
	}

	public Digestion source(String source) {
		if (source == null) this.message.remove("source");
		else this.message.set("source", source);
		return this;
	}

	public Digestion sourceTimetag(String sourceTimetag) {
		if (sourceTimetag == null) this.message.remove("sourceTimetag");
		else this.message.set("sourceTimetag", sourceTimetag);
		return this;
	}

	public Digestion bulks(Integer bulks) {
		this.message.set("bulks", bulks);
		return this;
	}

	public Digestion records(Integer records) {
		this.message.set("records", records);
		return this;
	}

	public Digestion invalidRecords(Integer invalidRecords) {
		this.message.set("invalidRecords", invalidRecords);
		return this;
	}

	public Digestion errors(Integer errors) {
		this.message.set("errors", errors);
		return this;
	}

	public Digestion warnings(Integer warnings) {
		this.message.set("warnings", warnings);
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}