package io.provista.datahub.events.cuentamaestra;

public class Reintegro extends io.intino.alexandria.event.Event implements java.io.Serializable {

	public Reintegro() {
		super("Reintegro");
	}

	public Reintegro(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Reintegro(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Reintegro ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Reintegro ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String anticipo() {
		return !message.contains("anticipo") ? null : message.get("anticipo").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public String expediente() {
		return !message.contains("expediente") ? null : message.get("expediente").asString();
	}

	public String ingreso() {
		return !message.contains("ingreso") ? null : message.get("ingreso").asString();
	}

	public String nuevoAnticipo() {
		return !message.contains("nuevoAnticipo") ? null : message.get("nuevoAnticipo").asString();
	}

	public String observaciones() {
		return !message.contains("observaciones") ? null : message.get("observaciones").asString();
	}

	public Long importe() {
		return message.get("importe").asLong();
	}

	public java.util.List<String> comprobantes() {
		return new java.util.ArrayList<String>(message.contains("comprobantes") ? java.util.Arrays.asList(message.get("comprobantes").as(String[].class)) : java.util.Collections.emptyList()) {
			@Override
			public boolean add(String value) {
				super.add(value);
				message.append("comprobantes", value);
				return true;
			}

			@Override
			public void add(int index, String element) {
				throw new UnsupportedOperationException();
			}

			@Override
			public boolean remove(Object value) {
				if (!(value instanceof String)) return false;
				super.remove(value);
				message.remove("comprobantes", value);
				return true;
			}

			@Override
			public String remove(int index) {
				String type = get(index);
				remove(type);
				return type;
			}

			@Override
			public boolean removeIf(java.util.function.Predicate<? super String> filter) {
				return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
			}

			@Override
			public boolean removeAll(java.util.Collection<?> c) {
				c.forEach(this::remove);
				return true;
			}

			@Override
			public boolean addAll(java.util.Collection<? extends String> c) {
				c.forEach(this::add);
				return true;
			}

			@Override
			public boolean addAll(int index, java.util.Collection<? extends String> c) {
				throw new UnsupportedOperationException();
			}

			public void clear() {
				super.clear();
				message.remove("comprobantes");
			}
		};
	}

	public Reintegro anticipo(String anticipo) {
		if (anticipo == null) this.message.remove("anticipo");
		else this.message.set("anticipo", anticipo);
		return this;
	}

	public Reintegro cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public Reintegro expediente(String expediente) {
		if (expediente == null) this.message.remove("expediente");
		else this.message.set("expediente", expediente);
		return this;
	}

	public Reintegro ingreso(String ingreso) {
		if (ingreso == null) this.message.remove("ingreso");
		else this.message.set("ingreso", ingreso);
		return this;
	}

	public Reintegro nuevoAnticipo(String nuevoAnticipo) {
		if (nuevoAnticipo == null) this.message.remove("nuevoAnticipo");
		else this.message.set("nuevoAnticipo", nuevoAnticipo);
		return this;
	}

	public Reintegro observaciones(String observaciones) {
		if (observaciones == null) this.message.remove("observaciones");
		else this.message.set("observaciones", observaciones);
		return this;
	}

	public Reintegro importe(Long importe) {
		if (importe == null) this.message.remove("importe");
		else this.message.set("importe", importe);
		return this;
	}

	public Reintegro comprobantes(java.util.List<String> comprobantes) {
		this.message.remove("comprobantes");
		comprobantes.forEach(v -> this.message.append("comprobantes", v));
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}