package io.provista.datahub.events.cuentamaestra;

public class PolizaDispersada extends io.intino.alexandria.event.Event implements java.io.Serializable {

	public PolizaDispersada() {
		super("PolizaDispersada");
	}

	public PolizaDispersada(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public PolizaDispersada(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public PolizaDispersada ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public PolizaDispersada ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String periodo() {
		return !message.contains("periodo") ? null : message.get("periodo").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public String poliza() {
		return !message.contains("poliza") ? null : message.get("poliza").asString();
	}

	public Integer tasaIva() {
		return message.get("tasaIva").asInteger();
	}

	public String fecha() {
		return !message.contains("fecha") ? null : message.get("fecha").asString();
	}

	public java.util.List<String> documentos() {
		return new java.util.ArrayList<String>(message.contains("documentos") ? java.util.Arrays.asList(message.get("documentos").as(String[].class)) : java.util.Collections.emptyList()) {
			@Override
			public boolean add(String value) {
				super.add(value);
				message.append("documentos", value);
				return true;
			}

			@Override
			public void add(int index, String element) {
				throw new UnsupportedOperationException();
			}

			@Override
			public boolean remove(Object value) {
				if (!(value instanceof String)) return false;
				super.remove(value);
				message.remove("documentos", value);
				return true;
			}

			@Override
			public String remove(int index) {
				String type = get(index);
				remove(type);
				return type;
			}

			@Override
			public boolean removeIf(java.util.function.Predicate<? super String> filter) {
				return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
			}

			@Override
			public boolean removeAll(java.util.Collection<?> c) {
				c.forEach(this::remove);
				return true;
			}

			@Override
			public boolean addAll(java.util.Collection<? extends String> c) {
				c.forEach(this::add);
				return true;
			}

			@Override
			public boolean addAll(int index, java.util.Collection<? extends String> c) {
				throw new UnsupportedOperationException();
			}

			public void clear() {
				super.clear();
				message.remove("documentos");
			}
		};
	}

	public PolizaDispersada periodo(String periodo) {
		if (periodo == null) this.message.remove("periodo");
		else this.message.set("periodo", periodo);
		return this;
	}

	public PolizaDispersada cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public PolizaDispersada poliza(String poliza) {
		if (poliza == null) this.message.remove("poliza");
		else this.message.set("poliza", poliza);
		return this;
	}

	public PolizaDispersada tasaIva(Integer tasaIva) {
		this.message.set("tasaIva", tasaIva);
		return this;
	}

	public PolizaDispersada fecha(String fecha) {
		if (fecha == null) this.message.remove("fecha");
		else this.message.set("fecha", fecha);
		return this;
	}

	public PolizaDispersada documentos(java.util.List<String> documentos) {
		this.message.remove("documentos");
		documentos.forEach(v -> this.message.append("documentos", v));
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}