package io.provista.datahub.events.cuentamaestra;

public class Poliza extends io.intino.alexandria.event.Event implements java.io.Serializable {

	public Poliza() {
		super("Poliza");
	}

	public Poliza(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Poliza(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Poliza ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Poliza ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String periodo() {
		return !message.contains("periodo") ? null : message.get("periodo").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public String poliza() {
		return !message.contains("poliza") ? null : message.get("poliza").asString();
	}

	public Integer tasaIva() {
		return message.get("tasaIva").asInteger();
	}

	public String fecha() {
		return !message.contains("fecha") ? null : message.get("fecha").asString();
	}

	public Long importe() {
		return message.get("importe").asLong();
	}

	public Poliza periodo(String periodo) {
		if (periodo == null) this.message.remove("periodo");
		else this.message.set("periodo", periodo);
		return this;
	}

	public Poliza cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public Poliza poliza(String poliza) {
		if (poliza == null) this.message.remove("poliza");
		else this.message.set("poliza", poliza);
		return this;
	}

	public Poliza tasaIva(Integer tasaIva) {
		this.message.set("tasaIva", tasaIva);
		return this;
	}

	public Poliza fecha(String fecha) {
		if (fecha == null) this.message.remove("fecha");
		else this.message.set("fecha", fecha);
		return this;
	}

	public Poliza importe(Long importe) {
		if (importe == null) this.message.remove("importe");
		else this.message.set("importe", importe);
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}