package io.provista.datahub.events.cuentamaestra;

public class GestionComercialSolicitada extends io.intino.alexandria.event.Event implements java.io.Serializable {


	public enum Modo {
		ConValidacion, SinValidacion
	}


	public GestionComercialSolicitada() {
		super("GestionComercialSolicitada");
	}

	public GestionComercialSolicitada(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public GestionComercialSolicitada(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public GestionComercialSolicitada ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public GestionComercialSolicitada ss(String ss) {
		super.ss(ss);
		return this;
	}

	public java.time.Instant fechaEmitida() {
		return !message.contains("fechaEmitida") ? null : message.get("fechaEmitida").asInstant();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public String periodo() {
		return !message.contains("periodo") ? null : message.get("periodo").asString();
	}

	public Long importeTotal() {
		return message.get("importeTotal").asLong();
	}

	public Long importeEnergia() {
		return message.get("importeEnergia").asLong();
	}

	public Long importeIVA() {
		return message.get("importeIVA").asLong();
	}

	public Long importeDAP() {
		return message.get("importeDAP").asLong();
	}

	public Double consumo() {
		return message.get("consumo").asDouble();
	}

	public String remesa() {
		return !message.contains("remesa") ? null : message.get("remesa").asString();
	}

	public Modo modo() {
		return !message.contains("modo") ? null : Modo.valueOf(message.get("modo").asString());
	}

	public GestionComercialSolicitada fechaEmitida(java.time.Instant fechaEmitida) {
		if (fechaEmitida == null) this.message.remove("fechaEmitida");
		else this.message.set("fechaEmitida", fechaEmitida);
		return this;
	}

	public GestionComercialSolicitada cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public GestionComercialSolicitada periodo(String periodo) {
		if (periodo == null) this.message.remove("periodo");
		else this.message.set("periodo", periodo);
		return this;
	}

	public GestionComercialSolicitada importeTotal(Long importeTotal) {
		if (importeTotal == null) this.message.remove("importeTotal");
		else this.message.set("importeTotal", importeTotal);
		return this;
	}

	public GestionComercialSolicitada importeEnergia(Long importeEnergia) {
		if (importeEnergia == null) this.message.remove("importeEnergia");
		else this.message.set("importeEnergia", importeEnergia);
		return this;
	}

	public GestionComercialSolicitada importeIVA(Long importeIVA) {
		if (importeIVA == null) this.message.remove("importeIVA");
		else this.message.set("importeIVA", importeIVA);
		return this;
	}

	public GestionComercialSolicitada importeDAP(Long importeDAP) {
		if (importeDAP == null) this.message.remove("importeDAP");
		else this.message.set("importeDAP", importeDAP);
		return this;
	}

	public GestionComercialSolicitada consumo(Double consumo) {
		this.message.set("consumo", consumo);
		return this;
	}

	public GestionComercialSolicitada remesa(String remesa) {
		if (remesa == null) this.message.remove("remesa");
		else this.message.set("remesa", remesa);
		return this;
	}

	public GestionComercialSolicitada modo(Modo modo) {
		if (modo == null) this.message.remove("modo");
		else this.message.set("modo", modo.name());
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}