package io.provista.datahub.events.cuentamaestra;

public class GestionCobroEliminada extends io.intino.alexandria.event.Event implements java.io.Serializable {

	public GestionCobroEliminada() {
		super("GestionCobroEliminada");
	}

	public GestionCobroEliminada(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public GestionCobroEliminada(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public GestionCobroEliminada ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public GestionCobroEliminada ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String expediente() {
		return !message.contains("expediente") ? null : message.get("expediente").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public String periodo() {
		return !message.contains("periodo") ? null : message.get("periodo").asString();
	}

	public String gestion() {
		return !message.contains("gestion") ? null : message.get("gestion").asString();
	}

	public String motivo() {
		return !message.contains("motivo") ? null : message.get("motivo").asString();
	}

	public GestionCobroEliminada expediente(String expediente) {
		if (expediente == null) this.message.remove("expediente");
		else this.message.set("expediente", expediente);
		return this;
	}

	public GestionCobroEliminada cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public GestionCobroEliminada periodo(String periodo) {
		if (periodo == null) this.message.remove("periodo");
		else this.message.set("periodo", periodo);
		return this;
	}

	public GestionCobroEliminada gestion(String gestion) {
		if (gestion == null) this.message.remove("gestion");
		else this.message.set("gestion", gestion);
		return this;
	}

	public GestionCobroEliminada motivo(String motivo) {
		if (motivo == null) this.message.remove("motivo");
		else this.message.set("motivo", motivo);
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}