package io.provista.datahub.events.cuentamaestra;

public class GestionCobro extends io.intino.alexandria.event.Event implements java.io.Serializable {
	private java.util.List<Historico> historicoList = null;

	public GestionCobro() {
		super("GestionCobro");
	}

	public GestionCobro(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public GestionCobro(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public GestionCobro ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public GestionCobro ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String expediente() {
		return !message.contains("expediente") ? null : message.get("expediente").asString();
	}

	public String id() {
		return !message.contains("id") ? null : message.get("id").asString();
	}

	public String tipo() {
		return !message.contains("tipo") ? null : message.get("tipo").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public String periodo() {
		return !message.contains("periodo") ? null : message.get("periodo").asString();
	}

	public String observaciones() {
		return !message.contains("observaciones") ? null : message.get("observaciones").asString();
	}

	public java.time.Instant fechaVencimiento() {
		return !message.contains("fechaVencimiento") ? null : message.get("fechaVencimiento").asInstant();
	}

	public Integer tasaInteres() {
		return message.get("tasaInteres").asInteger();
	}

	public Historico historico() {
		java.util.List<io.intino.alexandria.message.Message> components = message.components("Historico");
		return components.isEmpty() ? null : new Historico(components.get(0));
	}

	public GestionCobro expediente(String expediente) {
		if (expediente == null) this.message.remove("expediente");
		else this.message.set("expediente", expediente);
		return this;
	}

	public GestionCobro id(String id) {
		if (id == null) this.message.remove("id");
		else this.message.set("id", id);
		return this;
	}

	public GestionCobro tipo(String tipo) {
		if (tipo == null) this.message.remove("tipo");
		else this.message.set("tipo", tipo);
		return this;
	}

	public GestionCobro cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public GestionCobro periodo(String periodo) {
		if (periodo == null) this.message.remove("periodo");
		else this.message.set("periodo", periodo);
		return this;
	}

	public GestionCobro observaciones(String observaciones) {
		if (observaciones == null) this.message.remove("observaciones");
		else this.message.set("observaciones", observaciones);
		return this;
	}

	public GestionCobro fechaVencimiento(java.time.Instant fechaVencimiento) {
		if (fechaVencimiento == null) this.message.remove("fechaVencimiento");
		else this.message.set("fechaVencimiento", fechaVencimiento);
		return this;
	}

	public GestionCobro tasaInteres(Integer tasaInteres) {
		this.message.set("tasaInteres", tasaInteres);
		return this;
	}

	public GestionCobro historico(Historico historico) {
		this.message.components("Historico").forEach(v -> this.message.remove(v));
		if (historico != null) this.message.add(historico.toMessage());
		return this;
	}

	public static class Historico implements java.io.Serializable {
		protected io.intino.alexandria.message.Message message;

		public Historico() {
			this.message = new io.intino.alexandria.message.Message("Historico");
		}

		public Historico(io.intino.alexandria.message.Message message) {
			this.message = message;
		}

		public java.time.Instant fechaImportacion() {
			return !message.contains("fechaImportacion") ? null : message.get("fechaImportacion").asInstant();
		}

		public String notas() {
			return !message.contains("notas") ? null : message.get("notas").asString();
		}

		public String status() {
			return !message.contains("status") ? null : message.get("status").asString();
		}

		public Long importePendiente() {
			return message.get("importePendiente").asLong();
		}

		public Boolean esImportacionParcial() {
			return message.get("esImportacionParcial").asBoolean();
		}



		public Historico fechaImportacion(java.time.Instant fechaImportacion) {
			if (fechaImportacion == null) this.message.remove("fechaImportacion");
			else this.message.set("fechaImportacion", fechaImportacion);
			return this;
		}

		public Historico notas(String notas) {
			if (notas == null) this.message.remove("notas");
			else this.message.set("notas", notas);
			return this;
		}

		public Historico status(String status) {
			if (status == null) this.message.remove("status");
			else this.message.set("status", status);
			return this;
		}

		public Historico importePendiente(Long importePendiente) {
			if (importePendiente == null) this.message.remove("importePendiente");
			else this.message.set("importePendiente", importePendiente);
			return this;
		}

		public Historico esImportacionParcial(Boolean esImportacionParcial) {
			if (esImportacionParcial == null) this.message.remove("esImportacionParcial");
			else this.message.set("esImportacionParcial", esImportacionParcial);
			return this;
		}

		public io.intino.alexandria.message.Message toMessage() {
			return this.message;
		}
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}