package io.provista.datahub.events.cuentamaestra;

public class GestionAnticipo extends io.intino.alexandria.event.Event implements java.io.Serializable {


	public enum Estado {
		Vigente, Terminado, Cancelado
	}

	private java.util.List<Historico> historicoList = null;

	public GestionAnticipo() {
		super("GestionAnticipo");
	}

	public GestionAnticipo(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public GestionAnticipo(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public GestionAnticipo ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public GestionAnticipo ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String id() {
		return !message.contains("id") ? null : message.get("id").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public String observaciones() {
		return !message.contains("observaciones") ? null : message.get("observaciones").asString();
	}

	public Estado estado() {
		return !message.contains("estado") ? null : Estado.valueOf(message.get("estado").asString());
	}

	public Historico historico() {
		java.util.List<io.intino.alexandria.message.Message> components = message.components("Historico");
		return components.isEmpty() ? null : new Historico(components.get(0));
	}

	public GestionAnticipo id(String id) {
		if (id == null) this.message.remove("id");
		else this.message.set("id", id);
		return this;
	}

	public GestionAnticipo cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public GestionAnticipo observaciones(String observaciones) {
		if (observaciones == null) this.message.remove("observaciones");
		else this.message.set("observaciones", observaciones);
		return this;
	}

	public GestionAnticipo estado(Estado estado) {
		if (estado == null) this.message.remove("estado");
		else this.message.set("estado", estado.name());
		return this;
	}

	public GestionAnticipo historico(Historico historico) {
		this.message.components("Historico").forEach(v -> this.message.remove(v));
		if (historico != null) this.message.add(historico.toMessage());
		return this;
	}

	public static class Historico implements java.io.Serializable {
		protected io.intino.alexandria.message.Message message;

		public Historico() {
			this.message = new io.intino.alexandria.message.Message("Historico");
		}

		public Historico(io.intino.alexandria.message.Message message) {
			this.message = message;
		}

		public java.time.Instant fechaImportacion() {
			return !message.contains("fechaImportacion") ? null : message.get("fechaImportacion").asInstant();
		}

		public String status() {
			return !message.contains("status") ? null : message.get("status").asString();
		}

		public Long importePendiente() {
			return message.get("importePendiente").asLong();
		}

		public String notas() {
			return !message.contains("notas") ? null : message.get("notas").asString();
		}



		public Historico fechaImportacion(java.time.Instant fechaImportacion) {
			if (fechaImportacion == null) this.message.remove("fechaImportacion");
			else this.message.set("fechaImportacion", fechaImportacion);
			return this;
		}

		public Historico status(String status) {
			if (status == null) this.message.remove("status");
			else this.message.set("status", status);
			return this;
		}

		public Historico importePendiente(Long importePendiente) {
			if (importePendiente == null) this.message.remove("importePendiente");
			else this.message.set("importePendiente", importePendiente);
			return this;
		}

		public Historico notas(String notas) {
			if (notas == null) this.message.remove("notas");
			else this.message.set("notas", notas);
			return this;
		}

		public io.intino.alexandria.message.Message toMessage() {
			return this.message;
		}
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}