package io.provista.datahub.events.cuentamaestra;

public class Asiento extends io.intino.alexandria.event.Event implements java.io.Serializable {

	public Asiento() {
		super("Asiento");
	}

	public Asiento(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Asiento(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Asiento ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Asiento ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public String tipo() {
		return !message.contains("tipo") ? null : message.get("tipo").asString();
	}

	public Long importe() {
		return message.get("importe").asLong();
	}

	public java.util.List<String> comprobantes() {
		return new java.util.ArrayList<String>(message.contains("comprobantes") ? java.util.Arrays.asList(message.get("comprobantes").as(String[].class)) : java.util.Collections.emptyList()) {
			@Override
			public boolean add(String value) {
				super.add(value);
				message.append("comprobantes", value);
				return true;
			}

			@Override
			public void add(int index, String element) {
				throw new UnsupportedOperationException();
			}

			@Override
			public boolean remove(Object value) {
				if (!(value instanceof String)) return false;
				super.remove(value);
				message.remove("comprobantes", value);
				return true;
			}

			@Override
			public String remove(int index) {
				String type = get(index);
				remove(type);
				return type;
			}

			@Override
			public boolean removeIf(java.util.function.Predicate<? super String> filter) {
				return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
			}

			@Override
			public boolean removeAll(java.util.Collection<?> c) {
				c.forEach(this::remove);
				return true;
			}

			@Override
			public boolean addAll(java.util.Collection<? extends String> c) {
				c.forEach(this::add);
				return true;
			}

			@Override
			public boolean addAll(int index, java.util.Collection<? extends String> c) {
				throw new UnsupportedOperationException();
			}

			public void clear() {
				super.clear();
				message.remove("comprobantes");
			}
		};
	}

	public String objeto() {
		return !message.contains("objeto") ? null : message.get("objeto").asString();
	}

	public Asiento cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public Asiento tipo(String tipo) {
		if (tipo == null) this.message.remove("tipo");
		else this.message.set("tipo", tipo);
		return this;
	}

	public Asiento importe(Long importe) {
		if (importe == null) this.message.remove("importe");
		else this.message.set("importe", importe);
		return this;
	}

	public Asiento comprobantes(java.util.List<String> comprobantes) {
		this.message.remove("comprobantes");
		comprobantes.forEach(v -> this.message.append("comprobantes", v));
		return this;
	}

	public Asiento objeto(String objeto) {
		if (objeto == null) this.message.remove("objeto");
		else this.message.set("objeto", objeto);
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}