package io.provista.datahub.events.crm;

public class Reclamacion extends io.intino.alexandria.event.Event implements java.io.Serializable {


	public enum Tipo {
		AclaracionSaldo, NoLuz, DeficienciaVoltaje
	}

	public enum Estatus {
		Pendiente, Asignada, Terminada, Rechazada, Cancelada, CanceladaPorSistema, Preasignada
	}


	public Reclamacion() {
		super("Reclamacion");
	}

	public Reclamacion(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Reclamacion(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Reclamacion ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Reclamacion ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String id() {
		return !message.contains("id") ? null : message.get("id").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public Long rpu() {
		return message.get("rpu").asLong();
	}

	public java.time.Instant ultimaModificacion() {
		return !message.contains("ultimaModificacion") ? null : message.get("ultimaModificacion").asInstant();
	}

	public Tipo tipo() {
		return !message.contains("tipo") ? null : Tipo.valueOf(message.get("tipo").asString());
	}

	public Estatus estatus() {
		return !message.contains("estatus") ? null : Estatus.valueOf(message.get("estatus").asString());
	}

	public String detalle() {
		return !message.contains("detalle") ? null : message.get("detalle").asString();
	}

	public String resolucion() {
		return !message.contains("resolucion") ? null : message.get("resolucion").asString();
	}

	public Integer etaHours() {
		return message.get("etaHours").asInteger();
	}

	public Reclamacion id(String id) {
		if (id == null) this.message.remove("id");
		else this.message.set("id", id);
		return this;
	}

	public Reclamacion cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public Reclamacion rpu(Long rpu) {
		if (rpu == null) this.message.remove("rpu");
		else this.message.set("rpu", rpu);
		return this;
	}

	public Reclamacion ultimaModificacion(java.time.Instant ultimaModificacion) {
		if (ultimaModificacion == null) this.message.remove("ultimaModificacion");
		else this.message.set("ultimaModificacion", ultimaModificacion);
		return this;
	}

	public Reclamacion tipo(Tipo tipo) {
		if (tipo == null) this.message.remove("tipo");
		else this.message.set("tipo", tipo.name());
		return this;
	}

	public Reclamacion estatus(Estatus estatus) {
		if (estatus == null) this.message.remove("estatus");
		else this.message.set("estatus", estatus.name());
		return this;
	}

	public Reclamacion detalle(String detalle) {
		if (detalle == null) this.message.remove("detalle");
		else this.message.set("detalle", detalle);
		return this;
	}

	public Reclamacion resolucion(String resolucion) {
		if (resolucion == null) this.message.remove("resolucion");
		else this.message.set("resolucion", resolucion);
		return this;
	}

	public Reclamacion etaHours(Integer etaHours) {
		this.message.set("etaHours", etaHours);
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}