package io.provista.datahub.events.contratacion.judicial;

public class Expediente extends io.intino.alexandria.event.Event implements java.io.Serializable {


	public enum Resultado {
		Negativo, Positivo, Mixto
	}

	public enum Estado {
		Pendiente, Descartado, Terminado
	}


	public Expediente() {
		super("Expediente");
	}

	public Expediente(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Expediente(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Expediente ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Expediente ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String numero() {
		return !message.contains("numero") ? null : message.get("numero").asString();
	}

	public Integer version() {
		return message.get("version").asInteger();
	}

	public String solicitud() {
		return !message.contains("solicitud") ? null : message.get("solicitud").asString();
	}

	public Resultado resultado() {
		return !message.contains("resultado") ? null : Resultado.valueOf(message.get("resultado").asString());
	}

	public Estado estado() {
		return !message.contains("estado") ? null : Estado.valueOf(message.get("estado").asString());
	}

	public java.util.List<String> busquedas() {
		return new java.util.ArrayList<String>(message.contains("busquedas") ? java.util.Arrays.asList(message.get("busquedas").as(String[].class)) : java.util.Collections.emptyList()) {
			@Override
			public boolean add(String value) {
				super.add(value);
				message.append("busquedas", value);
				return true;
			}

			@Override
			public void add(int index, String element) {
				throw new UnsupportedOperationException();
			}

			@Override
			public boolean remove(Object value) {
				if (!(value instanceof String)) return false;
				super.remove(value);
				message.remove("busquedas", value);
				return true;
			}

			@Override
			public String remove(int index) {
				String type = get(index);
				remove(type);
				return type;
			}

			@Override
			public boolean removeIf(java.util.function.Predicate<? super String> filter) {
				return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
			}

			@Override
			public boolean removeAll(java.util.Collection<?> c) {
				c.forEach(this::remove);
				return true;
			}

			@Override
			public boolean addAll(java.util.Collection<? extends String> c) {
				c.forEach(this::add);
				return true;
			}

			@Override
			public boolean addAll(int index, java.util.Collection<? extends String> c) {
				throw new UnsupportedOperationException();
			}

			public void clear() {
				super.clear();
				message.remove("busquedas");
			}
		};
	}

	public java.util.List<String> comprobantes() {
		return new java.util.ArrayList<String>(message.contains("comprobantes") ? java.util.Arrays.asList(message.get("comprobantes").as(String[].class)) : java.util.Collections.emptyList()) {
			@Override
			public boolean add(String value) {
				super.add(value);
				message.append("comprobantes", value);
				return true;
			}

			@Override
			public void add(int index, String element) {
				throw new UnsupportedOperationException();
			}

			@Override
			public boolean remove(Object value) {
				if (!(value instanceof String)) return false;
				super.remove(value);
				message.remove("comprobantes", value);
				return true;
			}

			@Override
			public String remove(int index) {
				String type = get(index);
				remove(type);
				return type;
			}

			@Override
			public boolean removeIf(java.util.function.Predicate<? super String> filter) {
				return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
			}

			@Override
			public boolean removeAll(java.util.Collection<?> c) {
				c.forEach(this::remove);
				return true;
			}

			@Override
			public boolean addAll(java.util.Collection<? extends String> c) {
				c.forEach(this::add);
				return true;
			}

			@Override
			public boolean addAll(int index, java.util.Collection<? extends String> c) {
				throw new UnsupportedOperationException();
			}

			public void clear() {
				super.clear();
				message.remove("comprobantes");
			}
		};
	}

	public String firmante() {
		return !message.contains("firmante") ? null : message.get("firmante").asString();
	}

	public String autor() {
		return !message.contains("autor") ? null : message.get("autor").asString();
	}

	public String division() {
		return !message.contains("division") ? null : message.get("division").asString();
	}

	public Expediente numero(String numero) {
		if (numero == null) this.message.remove("numero");
		else this.message.set("numero", numero);
		return this;
	}

	public Expediente version(Integer version) {
		this.message.set("version", version);
		return this;
	}

	public Expediente solicitud(String solicitud) {
		if (solicitud == null) this.message.remove("solicitud");
		else this.message.set("solicitud", solicitud);
		return this;
	}

	public Expediente resultado(Resultado resultado) {
		if (resultado == null) this.message.remove("resultado");
		else this.message.set("resultado", resultado.name());
		return this;
	}

	public Expediente estado(Estado estado) {
		if (estado == null) this.message.remove("estado");
		else this.message.set("estado", estado.name());
		return this;
	}

	public Expediente busquedas(java.util.List<String> busquedas) {
		this.message.remove("busquedas");
		busquedas.forEach(v -> this.message.append("busquedas", v));
		return this;
	}

	public Expediente comprobantes(java.util.List<String> comprobantes) {
		this.message.remove("comprobantes");
		comprobantes.forEach(v -> this.message.append("comprobantes", v));
		return this;
	}

	public Expediente firmante(String firmante) {
		if (firmante == null) this.message.remove("firmante");
		else this.message.set("firmante", firmante);
		return this;
	}

	public Expediente autor(String autor) {
		if (autor == null) this.message.remove("autor");
		else this.message.set("autor", autor);
		return this;
	}

	public Expediente division(String division) {
		if (division == null) this.message.remove("division");
		else this.message.set("division", division);
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}