package io.provista.datahub.events.contratacion;

public class Convenio extends io.provista.datahub.events.contratacion.Acuerdo implements java.io.Serializable {


	public enum Tipo {
		CuentaMaestra, Recaudacion
	}

	private java.util.List<CuentaMaestra> cuentaMaestraList = null;
	private java.util.List<Recaudacion> recaudacionList = null;

	public Convenio() {
		super(new io.intino.alexandria.event.Event("Convenio"));
	}

	public Convenio(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Convenio(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Convenio ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Convenio ss(String ss) {
		super.ss(ss);
		return this;
	}

	public Tipo tipo() {
		return !message.contains("tipo") ? null : Tipo.valueOf(message.get("tipo").asString());
	}

	public String ejecutivo() {
		return !message.contains("ejecutivo") ? null : message.get("ejecutivo").asString();
	}

	public CuentaMaestra cuentaMaestra() {
		java.util.List<io.intino.alexandria.message.Message> components = message.components("CuentaMaestra");
		return components.isEmpty() ? null : new CuentaMaestra(components.get(0));
	}

	public Recaudacion recaudacion() {
		java.util.List<io.intino.alexandria.message.Message> components = message.components("Recaudacion");
		return components.isEmpty() ? null : new Recaudacion(components.get(0));
	}

	public Convenio tipo(Tipo tipo) {
		if (tipo == null) this.message.remove("tipo");
		else this.message.set("tipo", tipo.name());
		return this;
	}

	public Convenio ejecutivo(String ejecutivo) {
		if (ejecutivo == null) this.message.remove("ejecutivo");
		else this.message.set("ejecutivo", ejecutivo);
		return this;
	}

	public Convenio cuentaMaestra(CuentaMaestra cuentaMaestra) {
		this.message.components("CuentaMaestra").forEach(v -> this.message.remove(v));
		if (cuentaMaestra != null) this.message.add(cuentaMaestra.toMessage());
		return this;
	}

	public Convenio recaudacion(Recaudacion recaudacion) {
		this.message.components("Recaudacion").forEach(v -> this.message.remove(v));
		if (recaudacion != null) this.message.add(recaudacion.toMessage());
		return this;
	}

	public static class CuentaMaestra implements java.io.Serializable {
		public enum TipoConvenio {
			Normal, UsoPropio
		}

		public enum FacturaTipo {
			PPD, PUE
		}

		private java.util.List<AnticipoPeriodico> anticipoPeriodicoList = null;
		protected io.intino.alexandria.message.Message message;

		public CuentaMaestra() {
			this.message = new io.intino.alexandria.message.Message("CuentaMaestra");
		}

		public CuentaMaestra(io.intino.alexandria.message.Message message) {
			this.message = message;
		}

		public TipoConvenio tipoConvenio() {
			return !message.contains("tipoConvenio") ? null : TipoConvenio.valueOf(message.get("tipoConvenio").asString());
		}

		public String facturacionTipoCobranza() {
			return !message.contains("facturacionTipoCobranza") ? null : message.get("facturacionTipoCobranza").asString();
		}

		public FacturaTipo facturaTipo() {
			return !message.contains("facturaTipo") ? null : FacturaTipo.valueOf(message.get("facturaTipo").asString());
		}

		public String facturaUsoCFDI() {
			return !message.contains("facturaUsoCFDI") ? null : message.get("facturaUsoCFDI").asString();
		}

		public String pagoReferenciaBancaria() {
			return !message.contains("pagoReferenciaBancaria") ? null : message.get("pagoReferenciaBancaria").asString();
		}

		public String pagoCuentaBancaria() {
			return !message.contains("pagoCuentaBancaria") ? null : message.get("pagoCuentaBancaria").asString();
		}

		public String pagoTipo() {
			return !message.contains("pagoTipo") ? null : message.get("pagoTipo").asString();
		}

		public Integer morosidadDiasVencimiento() {
			return message.get("morosidadDiasVencimiento").asInteger();
		}

		public Integer morosidadInteresDiferencial() {
			return message.get("morosidadInteresDiferencial").asInteger();
		}

		public Boolean anticiposPermitenPagarDap() {
			return message.get("anticiposPermitenPagarDap").asBoolean();
		}

		public java.util.List<AnticipoPeriodico> anticipoPeriodicoList() {
			if (this.anticipoPeriodicoList != null) return this.anticipoPeriodicoList;
			return this.anticipoPeriodicoList = new java.util.ArrayList<AnticipoPeriodico>(message.components("AnticipoPeriodico").stream().map(c -> new AnticipoPeriodico(c)).collect(java.util.stream.Collectors.toList())) {
				@Override
				public boolean add(AnticipoPeriodico element) {
					super.add(element);
					message.add(element.toMessage());
					return true;
				}

				@Override
				public void add(int index, AnticipoPeriodico element) {
					throw new UnsupportedOperationException();
				}

				@Override
				public boolean remove(Object o) {
					if (!(o instanceof AnticipoPeriodico)) return false;
					super.remove(o);
					message.remove(((AnticipoPeriodico) o).toMessage());
					return true;
				}

				@Override
				public AnticipoPeriodico remove(int index) {
					AnticipoPeriodico type = get(index);
					remove(type);
					return type;
				}

				@Override
				public boolean removeIf(java.util.function.Predicate<? super AnticipoPeriodico> filter) {
					return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
				}

				@Override
				public boolean removeAll(java.util.Collection<?> c) {
					c.forEach(this::remove);
					return true;
				}

				@Override
				public boolean addAll(java.util.Collection<? extends AnticipoPeriodico> c) {
					c.forEach(this::add);
					return true;
				}

				@Override
				public boolean addAll(int index, java.util.Collection<? extends AnticipoPeriodico> c) {
					throw new UnsupportedOperationException();
				}
			};
		}

		public CuentaMaestra tipoConvenio(TipoConvenio tipoConvenio) {
			if (tipoConvenio == null) this.message.remove("tipoConvenio");
			else this.message.set("tipoConvenio", tipoConvenio.name());
			return this;
		}

		public CuentaMaestra facturacionTipoCobranza(String facturacionTipoCobranza) {
			if (facturacionTipoCobranza == null) this.message.remove("facturacionTipoCobranza");
			else this.message.set("facturacionTipoCobranza", facturacionTipoCobranza);
			return this;
		}

		public CuentaMaestra facturaTipo(FacturaTipo facturaTipo) {
			if (facturaTipo == null) this.message.remove("facturaTipo");
			else this.message.set("facturaTipo", facturaTipo.name());
			return this;
		}

		public CuentaMaestra facturaUsoCFDI(String facturaUsoCFDI) {
			if (facturaUsoCFDI == null) this.message.remove("facturaUsoCFDI");
			else this.message.set("facturaUsoCFDI", facturaUsoCFDI);
			return this;
		}

		public CuentaMaestra pagoReferenciaBancaria(String pagoReferenciaBancaria) {
			if (pagoReferenciaBancaria == null) this.message.remove("pagoReferenciaBancaria");
			else this.message.set("pagoReferenciaBancaria", pagoReferenciaBancaria);
			return this;
		}

		public CuentaMaestra pagoCuentaBancaria(String pagoCuentaBancaria) {
			if (pagoCuentaBancaria == null) this.message.remove("pagoCuentaBancaria");
			else this.message.set("pagoCuentaBancaria", pagoCuentaBancaria);
			return this;
		}

		public CuentaMaestra pagoTipo(String pagoTipo) {
			if (pagoTipo == null) this.message.remove("pagoTipo");
			else this.message.set("pagoTipo", pagoTipo);
			return this;
		}

		public CuentaMaestra morosidadDiasVencimiento(Integer morosidadDiasVencimiento) {
			this.message.set("morosidadDiasVencimiento", morosidadDiasVencimiento);
			return this;
		}

		public CuentaMaestra morosidadInteresDiferencial(Integer morosidadInteresDiferencial) {
			this.message.set("morosidadInteresDiferencial", morosidadInteresDiferencial);
			return this;
		}

		public CuentaMaestra anticiposPermitenPagarDap(Boolean anticiposPermitenPagarDap) {
			if (anticiposPermitenPagarDap == null) this.message.remove("anticiposPermitenPagarDap");
			else this.message.set("anticiposPermitenPagarDap", anticiposPermitenPagarDap);
			return this;
		}

		public CuentaMaestra anticipoPeriodicoList(java.util.List<AnticipoPeriodico> anticipoPeriodico) {
			new java.util.ArrayList(this.anticipoPeriodicoList()).forEach(v -> this.anticipoPeriodicoList.remove(v));
			this.anticipoPeriodicoList.addAll(anticipoPeriodico);
			return this;
		}

		public static class AnticipoPeriodico implements java.io.Serializable {
			protected io.intino.alexandria.message.Message message;

			public AnticipoPeriodico() {
				this.message = new io.intino.alexandria.message.Message("AnticipoPeriodico");
			}

			public AnticipoPeriodico(io.intino.alexandria.message.Message message) {
				this.message = message;
			}

			public Long total() {
				return message.get("total").asLong();
			}

			public Integer tasaIVA() {
				return message.get("tasaIVA").asInteger();
			}

			public Boolean emitirSinAminorar() {
				return message.get("emitirSinAminorar").asBoolean();
			}



			public AnticipoPeriodico total(Long total) {
				if (total == null) this.message.remove("total");
				else this.message.set("total", total);
				return this;
			}

			public AnticipoPeriodico tasaIVA(Integer tasaIVA) {
				this.message.set("tasaIVA", tasaIVA);
				return this;
			}

			public AnticipoPeriodico emitirSinAminorar(Boolean emitirSinAminorar) {
				if (emitirSinAminorar == null) this.message.remove("emitirSinAminorar");
				else this.message.set("emitirSinAminorar", emitirSinAminorar);
				return this;
			}

			public io.intino.alexandria.message.Message toMessage() {
				return this.message;
			}
		}

		public io.intino.alexandria.message.Message toMessage() {
			return this.message;
		}
	}

	public static class Recaudacion implements java.io.Serializable {
		public enum TipoConvenio {
			Domiciliacion, Ventanilla, Tarjeta, AdquiraTarjeta, Recurrente, Contracargo, Tpv
		}

		protected io.intino.alexandria.message.Message message;

		public Recaudacion() {
			this.message = new io.intino.alexandria.message.Message("Recaudacion");
		}

		public Recaudacion(io.intino.alexandria.message.Message message) {
			this.message = message;
		}

		public TipoConvenio tipoConvenio() {
			return !message.contains("tipoConvenio") ? null : TipoConvenio.valueOf(message.get("tipoConvenio").asString());
		}

		public String gestor() {
			return !message.contains("gestor") ? null : message.get("gestor").asString();
		}

		public String ftp() {
			return !message.contains("ftp") ? null : message.get("ftp").asString();
		}

		public String afiliacion() {
			return !message.contains("afiliacion") ? null : message.get("afiliacion").asString();
		}

		public String carpeta() {
			return !message.contains("carpeta") ? null : message.get("carpeta").asString();
		}

		public String facturaUsoCFDI() {
			return !message.contains("facturaUsoCFDI") ? null : message.get("facturaUsoCFDI").asString();
		}

		public Integer cuentaContable() {
			return message.get("cuentaContable").asInteger();
		}



		public Recaudacion tipoConvenio(TipoConvenio tipoConvenio) {
			if (tipoConvenio == null) this.message.remove("tipoConvenio");
			else this.message.set("tipoConvenio", tipoConvenio.name());
			return this;
		}

		public Recaudacion gestor(String gestor) {
			if (gestor == null) this.message.remove("gestor");
			else this.message.set("gestor", gestor);
			return this;
		}

		public Recaudacion ftp(String ftp) {
			if (ftp == null) this.message.remove("ftp");
			else this.message.set("ftp", ftp);
			return this;
		}

		public Recaudacion afiliacion(String afiliacion) {
			if (afiliacion == null) this.message.remove("afiliacion");
			else this.message.set("afiliacion", afiliacion);
			return this;
		}

		public Recaudacion carpeta(String carpeta) {
			if (carpeta == null) this.message.remove("carpeta");
			else this.message.set("carpeta", carpeta);
			return this;
		}

		public Recaudacion facturaUsoCFDI(String facturaUsoCFDI) {
			if (facturaUsoCFDI == null) this.message.remove("facturaUsoCFDI");
			else this.message.set("facturaUsoCFDI", facturaUsoCFDI);
			return this;
		}

		public Recaudacion cuentaContable(Integer cuentaContable) {
			this.message.set("cuentaContable", cuentaContable);
			return this;
		}

		public io.intino.alexandria.message.Message toMessage() {
			return this.message;
		}
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}