package io.provista.datahub.events.contratacion;

public class Contrato extends io.provista.datahub.events.contratacion.Acuerdo implements java.io.Serializable {


	public enum Tipo {
		Suministro, Generacion
	}

	private java.util.List<Generacion> generacionList = null;
	private java.util.List<MediosContacto> mediosContactoList = null;
	private java.util.List<Suministro> suministroList = null;

	public Contrato() {
		super(new io.intino.alexandria.event.Event("Contrato"));
	}

	public Contrato(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Contrato(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Contrato ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Contrato ss(String ss) {
		super.ss(ss);
		return this;
	}

	public Tipo tipo() {
		return !message.contains("tipo") ? null : Tipo.valueOf(message.get("tipo").asString());
	}

	public String agencia() {
		return !message.contains("agencia") ? null : message.get("agencia").asString();
	}

	public String ciclo() {
		return !message.contains("ciclo") ? null : message.get("ciclo").asString();
	}

	public String cuenta() {
		return !message.contains("cuenta") ? null : message.get("cuenta").asString();
	}

	public Long idServicio() {
		return message.get("idServicio").asLong();
	}

	public Generacion generacion() {
		java.util.List<io.intino.alexandria.message.Message> components = message.components("Generacion");
		return components.isEmpty() ? null : new Generacion(components.get(0));
	}

	public MediosContacto mediosContacto() {
		java.util.List<io.intino.alexandria.message.Message> components = message.components("MediosContacto");
		return components.isEmpty() ? null : new MediosContacto(components.get(0));
	}

	public Suministro suministro() {
		java.util.List<io.intino.alexandria.message.Message> components = message.components("Suministro");
		return components.isEmpty() ? null : new Suministro(components.get(0));
	}

	public Contrato tipo(Tipo tipo) {
		if (tipo == null) this.message.remove("tipo");
		else this.message.set("tipo", tipo.name());
		return this;
	}

	public Contrato agencia(String agencia) {
		if (agencia == null) this.message.remove("agencia");
		else this.message.set("agencia", agencia);
		return this;
	}

	public Contrato ciclo(String ciclo) {
		if (ciclo == null) this.message.remove("ciclo");
		else this.message.set("ciclo", ciclo);
		return this;
	}

	public Contrato cuenta(String cuenta) {
		if (cuenta == null) this.message.remove("cuenta");
		else this.message.set("cuenta", cuenta);
		return this;
	}

	public Contrato idServicio(Long idServicio) {
		if (idServicio == null) this.message.remove("idServicio");
		else this.message.set("idServicio", idServicio);
		return this;
	}

	public Contrato generacion(Generacion generacion) {
		this.message.components("Generacion").forEach(v -> this.message.remove(v));
		if (generacion != null) this.message.add(generacion.toMessage());
		return this;
	}

	public Contrato mediosContacto(MediosContacto mediosContacto) {
		this.message.components("MediosContacto").forEach(v -> this.message.remove(v));
		if (mediosContacto != null) this.message.add(mediosContacto.toMessage());
		return this;
	}

	public Contrato suministro(Suministro suministro) {
		this.message.components("Suministro").forEach(v -> this.message.remove(v));
		if (suministro != null) this.message.add(suministro.toMessage());
		return this;
	}

	public static class Generacion implements java.io.Serializable {
		public enum TipoContrato {
			Fotovoltaica, NetBilling, NetMetering, VentaTotal
		}

		private java.util.List<Localizacion> localizacionList = null;
		private java.util.List<Instalacion> instalacionList = null;
		protected io.intino.alexandria.message.Message message;

		public Generacion() {
			this.message = new io.intino.alexandria.message.Message("Generacion");
		}

		public Generacion(io.intino.alexandria.message.Message message) {
			this.message = message;
		}

		public String rmu() {
			return !message.contains("rmu") ? null : message.get("rmu").asString();
		}

		public TipoContrato tipoContrato() {
			return !message.contains("tipoContrato") ? null : TipoContrato.valueOf(message.get("tipoContrato").asString());
		}

		public java.time.Instant fechaAlta() {
			return !message.contains("fechaAlta") ? null : message.get("fechaAlta").asInstant();
		}

		public Double facturacionEstimada() {
			return message.get("facturacionEstimada").asDouble();
		}

		public String codigoSolicitudInterconexion() {
			return !message.contains("codigoSolicitudInterconexion") ? null : message.get("codigoSolicitudInterconexion").asString();
		}

		public Localizacion localizacion() {
			java.util.List<io.intino.alexandria.message.Message> components = message.components("Localizacion");
			return components.isEmpty() ? null : new Localizacion(components.get(0));
		}

		public Instalacion instalacion() {
			java.util.List<io.intino.alexandria.message.Message> components = message.components("Instalacion");
			return components.isEmpty() ? null : new Instalacion(components.get(0));
		}

		public Generacion rmu(String rmu) {
			if (rmu == null) this.message.remove("rmu");
			else this.message.set("rmu", rmu);
			return this;
		}

		public Generacion tipoContrato(TipoContrato tipoContrato) {
			if (tipoContrato == null) this.message.remove("tipoContrato");
			else this.message.set("tipoContrato", tipoContrato.name());
			return this;
		}

		public Generacion fechaAlta(java.time.Instant fechaAlta) {
			if (fechaAlta == null) this.message.remove("fechaAlta");
			else this.message.set("fechaAlta", fechaAlta);
			return this;
		}

		public Generacion facturacionEstimada(Double facturacionEstimada) {
			this.message.set("facturacionEstimada", facturacionEstimada);
			return this;
		}

		public Generacion codigoSolicitudInterconexion(String codigoSolicitudInterconexion) {
			if (codigoSolicitudInterconexion == null) this.message.remove("codigoSolicitudInterconexion");
			else this.message.set("codigoSolicitudInterconexion", codigoSolicitudInterconexion);
			return this;
		}

		public Generacion localizacion(Localizacion localizacion) {
			this.message.components("Localizacion").forEach(v -> this.message.remove(v));
			if (localizacion != null) this.message.add(localizacion.toMessage());
			return this;
		}

		public Generacion instalacion(Instalacion instalacion) {
			this.message.components("Instalacion").forEach(v -> this.message.remove(v));
			if (instalacion != null) this.message.add(instalacion.toMessage());
			return this;
		}

		public static class Localizacion implements java.io.Serializable {
			protected io.intino.alexandria.message.Message message;

			public Localizacion() {
				this.message = new io.intino.alexandria.message.Message("Localizacion");
			}

			public Localizacion(io.intino.alexandria.message.Message message) {
				this.message = message;
			}

			public String zona() {
				return !message.contains("zona") ? null : message.get("zona").asString();
			}

			public String zonaCarga() {
				return !message.contains("zonaCarga") ? null : message.get("zonaCarga").asString();
			}

			public String sistema() {
				return !message.contains("sistema") ? null : message.get("sistema").asString();
			}

			public String coordenadas() {
				return !message.contains("coordenadas") ? null : message.get("coordenadas").asString();
			}



			public Localizacion zona(String zona) {
				if (zona == null) this.message.remove("zona");
				else this.message.set("zona", zona);
				return this;
			}

			public Localizacion zonaCarga(String zonaCarga) {
				if (zonaCarga == null) this.message.remove("zonaCarga");
				else this.message.set("zonaCarga", zonaCarga);
				return this;
			}

			public Localizacion sistema(String sistema) {
				if (sistema == null) this.message.remove("sistema");
				else this.message.set("sistema", sistema);
				return this;
			}

			public Localizacion coordenadas(String coordenadas) {
				if (coordenadas == null) this.message.remove("coordenadas");
				else this.message.set("coordenadas", coordenadas);
				return this;
			}

			public io.intino.alexandria.message.Message toMessage() {
				return this.message;
			}
		}

		public static class Instalacion implements java.io.Serializable {
			protected io.intino.alexandria.message.Message message;

			public Instalacion() {
				this.message = new io.intino.alexandria.message.Message("Instalacion");
			}

			public Instalacion(io.intino.alexandria.message.Message message) {
				this.message = message;
			}

			public java.time.Instant fechaInstalacion() {
				return !message.contains("fechaInstalacion") ? null : message.get("fechaInstalacion").asInstant();
			}

			public Integer unidadesGeneracion() {
				return message.get("unidadesGeneracion").asInteger();
			}

			public Double potenciaInstalada() {
				return message.get("potenciaInstalada").asDouble();
			}

			public String tension() {
				return !message.contains("tension") ? null : message.get("tension").asString();
			}

			public String tecnologia() {
				return !message.contains("tecnologia") ? null : message.get("tecnologia").asString();
			}

			public java.util.List<String> medidores() {
				return new java.util.ArrayList<String>(message.contains("medidores") ? java.util.Arrays.asList(message.get("medidores").as(String[].class)) : java.util.Collections.emptyList()) {
					@Override
					public boolean add(String value) {
						super.add(value);
						message.append("medidores", value);
						return true;
					}

					@Override
					public void add(int index, String element) {
						throw new UnsupportedOperationException();
					}

					@Override
					public boolean remove(Object value) {
						if (!(value instanceof String)) return false;
						super.remove(value);
						message.remove("medidores", value);
						return true;
					}

					@Override
					public String remove(int index) {
						String type = get(index);
						remove(type);
						return type;
					}

					@Override
					public boolean removeIf(java.util.function.Predicate<? super String> filter) {
						return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
					}

					@Override
					public boolean removeAll(java.util.Collection<?> c) {
						c.forEach(this::remove);
						return true;
					}

					@Override
					public boolean addAll(java.util.Collection<? extends String> c) {
						c.forEach(this::add);
						return true;
					}

					@Override
					public boolean addAll(int index, java.util.Collection<? extends String> c) {
						throw new UnsupportedOperationException();
					}

					public void clear() {
						super.clear();
						message.remove("medidores");
					}
				};
			}



			public Instalacion fechaInstalacion(java.time.Instant fechaInstalacion) {
				if (fechaInstalacion == null) this.message.remove("fechaInstalacion");
				else this.message.set("fechaInstalacion", fechaInstalacion);
				return this;
			}

			public Instalacion unidadesGeneracion(Integer unidadesGeneracion) {
				this.message.set("unidadesGeneracion", unidadesGeneracion);
				return this;
			}

			public Instalacion potenciaInstalada(Double potenciaInstalada) {
				this.message.set("potenciaInstalada", potenciaInstalada);
				return this;
			}

			public Instalacion tension(String tension) {
				if (tension == null) this.message.remove("tension");
				else this.message.set("tension", tension);
				return this;
			}

			public Instalacion tecnologia(String tecnologia) {
				if (tecnologia == null) this.message.remove("tecnologia");
				else this.message.set("tecnologia", tecnologia);
				return this;
			}

			public Instalacion medidores(java.util.List<String> medidores) {
				this.message.remove("medidores");
				medidores.forEach(v -> this.message.append("medidores", v));
				return this;
			}

			public io.intino.alexandria.message.Message toMessage() {
				return this.message;
			}
		}

		public io.intino.alexandria.message.Message toMessage() {
			return this.message;
		}
	}

	public static class MediosContacto implements java.io.Serializable {
		protected io.intino.alexandria.message.Message message;

		public MediosContacto() {
			this.message = new io.intino.alexandria.message.Message("MediosContacto");
		}

		public MediosContacto(io.intino.alexandria.message.Message message) {
			this.message = message;
		}

		public java.util.List<String> emails() {
			return new java.util.ArrayList<String>(message.contains("emails") ? java.util.Arrays.asList(message.get("emails").as(String[].class)) : java.util.Collections.emptyList()) {
				@Override
				public boolean add(String value) {
					super.add(value);
					message.append("emails", value);
					return true;
				}

				@Override
				public void add(int index, String element) {
					throw new UnsupportedOperationException();
				}

				@Override
				public boolean remove(Object value) {
					if (!(value instanceof String)) return false;
					super.remove(value);
					message.remove("emails", value);
					return true;
				}

				@Override
				public String remove(int index) {
					String type = get(index);
					remove(type);
					return type;
				}

				@Override
				public boolean removeIf(java.util.function.Predicate<? super String> filter) {
					return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
				}

				@Override
				public boolean removeAll(java.util.Collection<?> c) {
					c.forEach(this::remove);
					return true;
				}

				@Override
				public boolean addAll(java.util.Collection<? extends String> c) {
					c.forEach(this::add);
					return true;
				}

				@Override
				public boolean addAll(int index, java.util.Collection<? extends String> c) {
					throw new UnsupportedOperationException();
				}

				public void clear() {
					super.clear();
					message.remove("emails");
				}
			};
		}

		public java.util.List<String> telefonos() {
			return new java.util.ArrayList<String>(message.contains("telefonos") ? java.util.Arrays.asList(message.get("telefonos").as(String[].class)) : java.util.Collections.emptyList()) {
				@Override
				public boolean add(String value) {
					super.add(value);
					message.append("telefonos", value);
					return true;
				}

				@Override
				public void add(int index, String element) {
					throw new UnsupportedOperationException();
				}

				@Override
				public boolean remove(Object value) {
					if (!(value instanceof String)) return false;
					super.remove(value);
					message.remove("telefonos", value);
					return true;
				}

				@Override
				public String remove(int index) {
					String type = get(index);
					remove(type);
					return type;
				}

				@Override
				public boolean removeIf(java.util.function.Predicate<? super String> filter) {
					return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
				}

				@Override
				public boolean removeAll(java.util.Collection<?> c) {
					c.forEach(this::remove);
					return true;
				}

				@Override
				public boolean addAll(java.util.Collection<? extends String> c) {
					c.forEach(this::add);
					return true;
				}

				@Override
				public boolean addAll(int index, java.util.Collection<? extends String> c) {
					throw new UnsupportedOperationException();
				}

				public void clear() {
					super.clear();
					message.remove("telefonos");
				}
			};
		}



		public MediosContacto emails(java.util.List<String> emails) {
			this.message.remove("emails");
			emails.forEach(v -> this.message.append("emails", v));
			return this;
		}

		public MediosContacto telefonos(java.util.List<String> telefonos) {
			this.message.remove("telefonos");
			telefonos.forEach(v -> this.message.append("telefonos", v));
			return this;
		}

		public io.intino.alexandria.message.Message toMessage() {
			return this.message;
		}
	}

	public static class Suministro implements java.io.Serializable {
		public enum TipoContrato {
			Normal, UsoPropio, UltimoRecurso, Empleado
		}

		public enum TipoFacturacion {
			Mensual, BimestralPares, BimestralNones, TetramestralEnero, TetramestralFebrero, TetramestralMarzo, TetramestralAbril, Temporales, CiclosEspeciales
		}

		public enum GiroCFE {
			IndustrialAgropecuaria, IndustrialExtractiva, IndustrialTransformacion, IndustrialMinera, IndustrialConstruccion, IndustrialEnergia, Comercial, Transporte, Residencial, GobiernoFederal, GobiernoEstatal, GobiernoMunicipal, Servicios, SectorParaestatal, Otros
		}

		private java.util.List<Localizacion> localizacionList = null;
		private java.util.List<Instalacion> instalacionList = null;
		protected io.intino.alexandria.message.Message message;

		public Suministro() {
			this.message = new io.intino.alexandria.message.Message("Suministro");
		}

		public Suministro(io.intino.alexandria.message.Message message) {
			this.message = message;
		}

		public TipoContrato tipoContrato() {
			return !message.contains("tipoContrato") ? null : TipoContrato.valueOf(message.get("tipoContrato").asString());
		}

		public TipoFacturacion tipoFacturacion() {
			return !message.contains("tipoFacturacion") ? null : TipoFacturacion.valueOf(message.get("tipoFacturacion").asString());
		}

		public String tarifa() {
			return !message.contains("tarifa") ? null : message.get("tarifa").asString();
		}

		public Boolean tarifaDAC() {
			return message.get("tarifaDAC").asBoolean();
		}

		public String tarifaAutogestion() {
			return !message.contains("tarifaAutogestion") ? null : message.get("tarifaAutogestion").asString();
		}

		public String scian() {
			return !message.contains("scian") ? null : message.get("scian").asString();
		}

		public GiroCFE giroCFE() {
			return !message.contains("giroCFE") ? null : GiroCFE.valueOf(message.get("giroCFE").asString());
		}

		public Localizacion localizacion() {
			java.util.List<io.intino.alexandria.message.Message> components = message.components("Localizacion");
			return components.isEmpty() ? null : new Localizacion(components.get(0));
		}

		public Instalacion instalacion() {
			java.util.List<io.intino.alexandria.message.Message> components = message.components("Instalacion");
			return components.isEmpty() ? null : new Instalacion(components.get(0));
		}

		public Suministro tipoContrato(TipoContrato tipoContrato) {
			if (tipoContrato == null) this.message.remove("tipoContrato");
			else this.message.set("tipoContrato", tipoContrato.name());
			return this;
		}

		public Suministro tipoFacturacion(TipoFacturacion tipoFacturacion) {
			if (tipoFacturacion == null) this.message.remove("tipoFacturacion");
			else this.message.set("tipoFacturacion", tipoFacturacion.name());
			return this;
		}

		public Suministro tarifa(String tarifa) {
			if (tarifa == null) this.message.remove("tarifa");
			else this.message.set("tarifa", tarifa);
			return this;
		}

		public Suministro tarifaDAC(Boolean tarifaDAC) {
			if (tarifaDAC == null) this.message.remove("tarifaDAC");
			else this.message.set("tarifaDAC", tarifaDAC);
			return this;
		}

		public Suministro tarifaAutogestion(String tarifaAutogestion) {
			if (tarifaAutogestion == null) this.message.remove("tarifaAutogestion");
			else this.message.set("tarifaAutogestion", tarifaAutogestion);
			return this;
		}

		public Suministro scian(String scian) {
			if (scian == null) this.message.remove("scian");
			else this.message.set("scian", scian);
			return this;
		}

		public Suministro giroCFE(GiroCFE giroCFE) {
			if (giroCFE == null) this.message.remove("giroCFE");
			else this.message.set("giroCFE", giroCFE.name());
			return this;
		}

		public Suministro localizacion(Localizacion localizacion) {
			this.message.components("Localizacion").forEach(v -> this.message.remove(v));
			if (localizacion != null) this.message.add(localizacion.toMessage());
			return this;
		}

		public Suministro instalacion(Instalacion instalacion) {
			this.message.components("Instalacion").forEach(v -> this.message.remove(v));
			if (instalacion != null) this.message.add(instalacion.toMessage());
			return this;
		}

		public static class Localizacion implements java.io.Serializable {
			protected io.intino.alexandria.message.Message message;

			public Localizacion() {
				this.message = new io.intino.alexandria.message.Message("Localizacion");
			}

			public Localizacion(io.intino.alexandria.message.Message message) {
				this.message = message;
			}

			public String direccion() {
				return !message.contains("direccion") ? null : message.get("direccion").asString();
			}

			public java.util.List<String> callesAdyacentes() {
				return new java.util.ArrayList<String>(message.contains("callesAdyacentes") ? java.util.Arrays.asList(message.get("callesAdyacentes").as(String[].class)) : java.util.Collections.emptyList()) {
					@Override
					public boolean add(String value) {
						super.add(value);
						message.append("callesAdyacentes", value);
						return true;
					}

					@Override
					public void add(int index, String element) {
						throw new UnsupportedOperationException();
					}

					@Override
					public boolean remove(Object value) {
						if (!(value instanceof String)) return false;
						super.remove(value);
						message.remove("callesAdyacentes", value);
						return true;
					}

					@Override
					public String remove(int index) {
						String type = get(index);
						remove(type);
						return type;
					}

					@Override
					public boolean removeIf(java.util.function.Predicate<? super String> filter) {
						return removeAll(java.util.stream.IntStream.range(0, this.size()).filter(i -> filter.test(get(i))).mapToObj(this::get).collect(java.util.stream.Collectors.toList()));
					}

					@Override
					public boolean removeAll(java.util.Collection<?> c) {
						c.forEach(this::remove);
						return true;
					}

					@Override
					public boolean addAll(java.util.Collection<? extends String> c) {
						c.forEach(this::add);
						return true;
					}

					@Override
					public boolean addAll(int index, java.util.Collection<? extends String> c) {
						throw new UnsupportedOperationException();
					}

					public void clear() {
						super.clear();
						message.remove("callesAdyacentes");
					}
				};
			}

			public String colonia() {
				return !message.contains("colonia") ? null : message.get("colonia").asString();
			}

			public String municipio() {
				return !message.contains("municipio") ? null : message.get("municipio").asString();
			}

			public String estado() {
				return !message.contains("estado") ? null : message.get("estado").asString();
			}

			public String codigoPostal() {
				return !message.contains("codigoPostal") ? null : message.get("codigoPostal").asString();
			}

			public String coordenadas() {
				return !message.contains("coordenadas") ? null : message.get("coordenadas").asString();
			}



			public Localizacion direccion(String direccion) {
				if (direccion == null) this.message.remove("direccion");
				else this.message.set("direccion", direccion);
				return this;
			}

			public Localizacion callesAdyacentes(java.util.List<String> callesAdyacentes) {
				this.message.remove("callesAdyacentes");
				callesAdyacentes.forEach(v -> this.message.append("callesAdyacentes", v));
				return this;
			}

			public Localizacion colonia(String colonia) {
				if (colonia == null) this.message.remove("colonia");
				else this.message.set("colonia", colonia);
				return this;
			}

			public Localizacion municipio(String municipio) {
				if (municipio == null) this.message.remove("municipio");
				else this.message.set("municipio", municipio);
				return this;
			}

			public Localizacion estado(String estado) {
				if (estado == null) this.message.remove("estado");
				else this.message.set("estado", estado);
				return this;
			}

			public Localizacion codigoPostal(String codigoPostal) {
				if (codigoPostal == null) this.message.remove("codigoPostal");
				else this.message.set("codigoPostal", codigoPostal);
				return this;
			}

			public Localizacion coordenadas(String coordenadas) {
				if (coordenadas == null) this.message.remove("coordenadas");
				else this.message.set("coordenadas", coordenadas);
				return this;
			}

			public io.intino.alexandria.message.Message toMessage() {
				return this.message;
			}
		}

		public static class Instalacion implements java.io.Serializable {
			public enum TipoSuministro {
				AltaMediaTensionPrimario, AltaMediaTensionSecundario, BajaTensionSecundario, BajaTensionPrimario
			}

			protected io.intino.alexandria.message.Message message;

			public Instalacion() {
				this.message = new io.intino.alexandria.message.Message("Instalacion");
			}

			public Instalacion(io.intino.alexandria.message.Message message) {
				this.message = message;
			}

			public Double potenciaContratada() {
				return message.get("potenciaContratada").asDouble();
			}

			public Double potenciaInstalada() {
				return message.get("potenciaInstalada").asDouble();
			}

			public Integer hilos() {
				return message.get("hilos").asInteger();
			}

			public TipoSuministro tipoSuministro() {
				return !message.contains("tipoSuministro") ? null : TipoSuministro.valueOf(message.get("tipoSuministro").asString());
			}



			public Instalacion potenciaContratada(Double potenciaContratada) {
				this.message.set("potenciaContratada", potenciaContratada);
				return this;
			}

			public Instalacion potenciaInstalada(Double potenciaInstalada) {
				this.message.set("potenciaInstalada", potenciaInstalada);
				return this;
			}

			public Instalacion hilos(Integer hilos) {
				this.message.set("hilos", hilos);
				return this;
			}

			public Instalacion tipoSuministro(TipoSuministro tipoSuministro) {
				if (tipoSuministro == null) this.message.remove("tipoSuministro");
				else this.message.set("tipoSuministro", tipoSuministro.name());
				return this;
			}

			public io.intino.alexandria.message.Message toMessage() {
				return this.message;
			}
		}

		public io.intino.alexandria.message.Message toMessage() {
			return this.message;
		}
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}