package io.provista.datahub.events.contratacion;

public class Acuerdo extends io.intino.alexandria.event.Event implements java.io.Serializable {


	public enum Estado {
		Borrador, Sustituido, Activado, Rescindido
	}

	public enum Giro {
		Gobierno, Privado
	}

	public enum TipoPersona {
		Fisica, Moral
	}

	private java.util.List<Direccion> direccionList = null;

	public Acuerdo() {
		super("Acuerdo");
	}

	public Acuerdo(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Acuerdo(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Acuerdo ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Acuerdo ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String id() {
		return !message.contains("id") ? null : message.get("id").asString();
	}

	public String codigo() {
		return !message.contains("codigo") ? null : message.get("codigo").asString();
	}

	public Estado estado() {
		return !message.contains("estado") ? null : Estado.valueOf(message.get("estado").asString());
	}

	public Giro giro() {
		return !message.contains("giro") ? null : Giro.valueOf(message.get("giro").asString());
	}

	public String rfc() {
		return !message.contains("rfc") ? null : message.get("rfc").asString();
	}

	public String nombre() {
		return !message.contains("nombre") ? null : message.get("nombre").asString();
	}

	public TipoPersona tipoPersona() {
		return !message.contains("tipoPersona") ? null : TipoPersona.valueOf(message.get("tipoPersona").asString());
	}

	public String alias() {
		return !message.contains("alias") ? null : message.get("alias").asString();
	}

	public String division() {
		return !message.contains("division") ? null : message.get("division").asString();
	}

	public Direccion direccion() {
		java.util.List<io.intino.alexandria.message.Message> components = message.components("Direccion");
		return components.isEmpty() ? null : new Direccion(components.get(0));
	}

	public Acuerdo id(String id) {
		if (id == null) this.message.remove("id");
		else this.message.set("id", id);
		return this;
	}

	public Acuerdo codigo(String codigo) {
		if (codigo == null) this.message.remove("codigo");
		else this.message.set("codigo", codigo);
		return this;
	}

	public Acuerdo estado(Estado estado) {
		if (estado == null) this.message.remove("estado");
		else this.message.set("estado", estado.name());
		return this;
	}

	public Acuerdo giro(Giro giro) {
		if (giro == null) this.message.remove("giro");
		else this.message.set("giro", giro.name());
		return this;
	}

	public Acuerdo rfc(String rfc) {
		if (rfc == null) this.message.remove("rfc");
		else this.message.set("rfc", rfc);
		return this;
	}

	public Acuerdo nombre(String nombre) {
		if (nombre == null) this.message.remove("nombre");
		else this.message.set("nombre", nombre);
		return this;
	}

	public Acuerdo tipoPersona(TipoPersona tipoPersona) {
		if (tipoPersona == null) this.message.remove("tipoPersona");
		else this.message.set("tipoPersona", tipoPersona.name());
		return this;
	}

	public Acuerdo alias(String alias) {
		if (alias == null) this.message.remove("alias");
		else this.message.set("alias", alias);
		return this;
	}

	public Acuerdo division(String division) {
		if (division == null) this.message.remove("division");
		else this.message.set("division", division);
		return this;
	}

	public Acuerdo direccion(Direccion direccion) {
		this.message.components("Direccion").forEach(v -> this.message.remove(v));
		if (direccion != null) this.message.add(direccion.toMessage());
		return this;
	}

	public static class Direccion implements java.io.Serializable {
		protected io.intino.alexandria.message.Message message;

		public Direccion() {
			this.message = new io.intino.alexandria.message.Message("Direccion");
		}

		public Direccion(io.intino.alexandria.message.Message message) {
			this.message = message;
		}

		public String calle() {
			return !message.contains("calle") ? null : message.get("calle").asString();
		}

		public String numero() {
			return !message.contains("numero") ? null : message.get("numero").asString();
		}

		public String numeroInterior() {
			return !message.contains("numeroInterior") ? null : message.get("numeroInterior").asString();
		}

		public String colonia() {
			return !message.contains("colonia") ? null : message.get("colonia").asString();
		}

		public String localidad() {
			return !message.contains("localidad") ? null : message.get("localidad").asString();
		}

		public String municipio() {
			return !message.contains("municipio") ? null : message.get("municipio").asString();
		}

		public String estado() {
			return !message.contains("estado") ? null : message.get("estado").asString();
		}

		public String pais() {
			return !message.contains("pais") ? null : message.get("pais").asString();
		}

		public String codigoPostal() {
			return !message.contains("codigoPostal") ? null : message.get("codigoPostal").asString();
		}



		public Direccion calle(String calle) {
			if (calle == null) this.message.remove("calle");
			else this.message.set("calle", calle);
			return this;
		}

		public Direccion numero(String numero) {
			if (numero == null) this.message.remove("numero");
			else this.message.set("numero", numero);
			return this;
		}

		public Direccion numeroInterior(String numeroInterior) {
			if (numeroInterior == null) this.message.remove("numeroInterior");
			else this.message.set("numeroInterior", numeroInterior);
			return this;
		}

		public Direccion colonia(String colonia) {
			if (colonia == null) this.message.remove("colonia");
			else this.message.set("colonia", colonia);
			return this;
		}

		public Direccion localidad(String localidad) {
			if (localidad == null) this.message.remove("localidad");
			else this.message.set("localidad", localidad);
			return this;
		}

		public Direccion municipio(String municipio) {
			if (municipio == null) this.message.remove("municipio");
			else this.message.set("municipio", municipio);
			return this;
		}

		public Direccion estado(String estado) {
			if (estado == null) this.message.remove("estado");
			else this.message.set("estado", estado);
			return this;
		}

		public Direccion pais(String pais) {
			if (pais == null) this.message.remove("pais");
			else this.message.set("pais", pais);
			return this;
		}

		public Direccion codigoPostal(String codigoPostal) {
			if (codigoPostal == null) this.message.remove("codigoPostal");
			else this.message.set("codigoPostal", codigoPostal);
			return this;
		}

		public io.intino.alexandria.message.Message toMessage() {
			return this.message;
		}
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}