package io.provista.datahub.events.bitacora;

public class Cobro extends io.intino.alexandria.event.Event implements java.io.Serializable {
	public enum Split {
		D2 {
			public String qn() {
				return "D2";
			}
		}, DA {
			public String qn() {
				return "DA";
			}
		}, DB {
			public String qn() {
				return "DB";
			}
		}, DC {
			public String qn() {
				return "DC";
			}
		}, DD {
			public String qn() {
				return "DD";
			}
		}, DF {
			public String qn() {
				return "DF";
			}
		}, DG {
			public String qn() {
				return "DG";
			}
		}, DJ {
			public String qn() {
				return "DJ";
			}
		}, DK {
			public String qn() {
				return "DK";
			}
		}, DL {
			public String qn() {
				return "DL";
			}
		}, DM {
			public String qn() {
				return "DM";
			}
		}, DN {
			public String qn() {
				return "DN";
			}
		}, DP {
			public String qn() {
				return "DP";
			}
		}, DU {
			public String qn() {
				return "DU";
			}
		}, DV {
			public String qn() {
				return "DV";
			}
		}, DW {
			public String qn() {
				return "DW";
			}
		}, DX {
			public String qn() {
				return "DX";
			}
		};

		public abstract String qn();

		public static Split splitByQn(String qn) {
			return java.util.Arrays.stream(values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);
		}
	}

	public Cobro() {
		super("Cobro");
	}

	public Cobro(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Cobro(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Cobro ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Cobro ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String ocr() {
		return !message.contains("ocr") ? null : message.get("ocr").asString();
	}

	public String agencia() {
		return !message.contains("agencia") ? null : message.get("agencia").asString();
	}

	public Long importe() {
		return message.get("importe").asLong();
	}

	public String medioCobranza() {
		return !message.contains("medioCobranza") ? null : message.get("medioCobranza").asString();
	}

	public String claveOperador() {
		return !message.contains("claveOperador") ? null : message.get("claveOperador").asString();
	}

	public Cobro ocr(String ocr) {
		if (ocr == null) this.message.remove("ocr");
		else this.message.set("ocr", ocr);
		return this;
	}

	public Cobro agencia(String agencia) {
		if (agencia == null) this.message.remove("agencia");
		else this.message.set("agencia", agencia);
		return this;
	}

	public Cobro importe(Long importe) {
		if (importe == null) this.message.remove("importe");
		else this.message.set("importe", importe);
		return this;
	}

	public Cobro medioCobranza(String medioCobranza) {
		if (medioCobranza == null) this.message.remove("medioCobranza");
		else this.message.set("medioCobranza", medioCobranza);
		return this;
	}

	public Cobro claveOperador(String claveOperador) {
		if (claveOperador == null) this.message.remove("claveOperador");
		else this.message.set("claveOperador", claveOperador);
		return this;
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}