package io.provista.datahub.events.bitacora;

public class Adeudo extends io.intino.alexandria.event.Event implements java.io.Serializable {
	public enum Split {
		D2 {
			public String qn() {
				return "D2";
			}
		}, DA {
			public String qn() {
				return "DA";
			}
		}, DB {
			public String qn() {
				return "DB";
			}
		}, DC {
			public String qn() {
				return "DC";
			}
		}, DD {
			public String qn() {
				return "DD";
			}
		}, DF {
			public String qn() {
				return "DF";
			}
		}, DG {
			public String qn() {
				return "DG";
			}
		}, DJ {
			public String qn() {
				return "DJ";
			}
		}, DK {
			public String qn() {
				return "DK";
			}
		}, DL {
			public String qn() {
				return "DL";
			}
		}, DM {
			public String qn() {
				return "DM";
			}
		}, DN {
			public String qn() {
				return "DN";
			}
		}, DP {
			public String qn() {
				return "DP";
			}
		}, DU {
			public String qn() {
				return "DU";
			}
		}, DV {
			public String qn() {
				return "DV";
			}
		}, DW {
			public String qn() {
				return "DW";
			}
		}, DX {
			public String qn() {
				return "DX";
			}
		};

		public abstract String qn();

		public static Split splitByQn(String qn) {
			return java.util.Arrays.stream(values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);
		}
	}
	private java.util.List<Detalle> detalleList = null;

	public Adeudo() {
		super("Adeudo");
	}

	public Adeudo(io.intino.alexandria.event.Event event) {
		this(event.toMessage());
	}

	public Adeudo(io.intino.alexandria.message.Message message) {
		super(message);
	}

	public Adeudo ts(java.time.Instant ts) {
		super.ts(ts);
		return this;
	}

	public Adeudo ss(String ss) {
		super.ss(ss);
		return this;
	}

	public String ocr() {
		return !message.contains("ocr") ? null : message.get("ocr").asString();
	}

	public String agencia() {
		return !message.contains("agencia") ? null : message.get("agencia").asString();
	}

	public Long importeTotal() {
		return message.get("importeTotal").asLong();
	}

	public Long kwh() {
		return message.get("kwh").asLong();
	}

	public Integer tasaIva() {
		return message.get("tasaIva").asInteger();
	}

	public String fechaVencimiento() {
		return !message.contains("fechaVencimiento") ? null : message.get("fechaVencimiento").asString();
	}

	public Detalle detalle() {
		java.util.List<io.intino.alexandria.message.Message> components = message.components("Detalle");
		return components.isEmpty() ? null : new Detalle(components.get(0));
	}

	public Adeudo ocr(String ocr) {
		if (ocr == null) this.message.remove("ocr");
		else this.message.set("ocr", ocr);
		return this;
	}

	public Adeudo agencia(String agencia) {
		if (agencia == null) this.message.remove("agencia");
		else this.message.set("agencia", agencia);
		return this;
	}

	public Adeudo importeTotal(Long importeTotal) {
		if (importeTotal == null) this.message.remove("importeTotal");
		else this.message.set("importeTotal", importeTotal);
		return this;
	}

	public Adeudo kwh(Long kwh) {
		if (kwh == null) this.message.remove("kwh");
		else this.message.set("kwh", kwh);
		return this;
	}

	public Adeudo tasaIva(Integer tasaIva) {
		this.message.set("tasaIva", tasaIva);
		return this;
	}

	public Adeudo fechaVencimiento(String fechaVencimiento) {
		if (fechaVencimiento == null) this.message.remove("fechaVencimiento");
		else this.message.set("fechaVencimiento", fechaVencimiento);
		return this;
	}

	public Adeudo detalle(Detalle detalle) {
		this.message.components("Detalle").forEach(v -> this.message.remove(v));
		if (detalle != null) this.message.add(detalle.toMessage());
		return this;
	}

	public static class Detalle implements java.io.Serializable {
		protected io.intino.alexandria.message.Message message;

		public Detalle() {
			this.message = new io.intino.alexandria.message.Message("Detalle");
		}

		public Detalle(io.intino.alexandria.message.Message message) {
			this.message = message;
		}

		public Long importeEnergia() {
			return message.get("importeEnergia").asLong();
		}

		public Long importeEnergiaReactiva() {
			return message.get("importeEnergiaReactiva").asLong();
		}

		public Long importeMantenimiento() {
			return message.get("importeMantenimiento").asLong();
		}

		public Long importeIva() {
			return message.get("importeIva").asLong();
		}

		public Long importeDap() {
			return message.get("importeDap").asLong();
		}

		public Long impuestoSubsidio() {
			return message.get("impuestoSubsidio").asLong();
		}

		public Long importeCargo() {
			return message.get("importeCargo").asLong();
		}

		public Long importeCredito() {
			return message.get("importeCredito").asLong();
		}

		public Long importeDeposito() {
			return message.get("importeDeposito").asLong();
		}

		public Long cargoCfe() {
			return message.get("cargoCfe").asLong();
		}

		public Long difMas() {
			return message.get("difMas").asLong();
		}

		public Long difMenos() {
			return message.get("difMenos").asLong();
		}



		public Detalle importeEnergia(Long importeEnergia) {
			if (importeEnergia == null) this.message.remove("importeEnergia");
			else this.message.set("importeEnergia", importeEnergia);
			return this;
		}

		public Detalle importeEnergiaReactiva(Long importeEnergiaReactiva) {
			if (importeEnergiaReactiva == null) this.message.remove("importeEnergiaReactiva");
			else this.message.set("importeEnergiaReactiva", importeEnergiaReactiva);
			return this;
		}

		public Detalle importeMantenimiento(Long importeMantenimiento) {
			if (importeMantenimiento == null) this.message.remove("importeMantenimiento");
			else this.message.set("importeMantenimiento", importeMantenimiento);
			return this;
		}

		public Detalle importeIva(Long importeIva) {
			if (importeIva == null) this.message.remove("importeIva");
			else this.message.set("importeIva", importeIva);
			return this;
		}

		public Detalle importeDap(Long importeDap) {
			if (importeDap == null) this.message.remove("importeDap");
			else this.message.set("importeDap", importeDap);
			return this;
		}

		public Detalle impuestoSubsidio(Long impuestoSubsidio) {
			if (impuestoSubsidio == null) this.message.remove("impuestoSubsidio");
			else this.message.set("impuestoSubsidio", impuestoSubsidio);
			return this;
		}

		public Detalle importeCargo(Long importeCargo) {
			if (importeCargo == null) this.message.remove("importeCargo");
			else this.message.set("importeCargo", importeCargo);
			return this;
		}

		public Detalle importeCredito(Long importeCredito) {
			if (importeCredito == null) this.message.remove("importeCredito");
			else this.message.set("importeCredito", importeCredito);
			return this;
		}

		public Detalle importeDeposito(Long importeDeposito) {
			if (importeDeposito == null) this.message.remove("importeDeposito");
			else this.message.set("importeDeposito", importeDeposito);
			return this;
		}

		public Detalle cargoCfe(Long cargoCfe) {
			if (cargoCfe == null) this.message.remove("cargoCfe");
			else this.message.set("cargoCfe", cargoCfe);
			return this;
		}

		public Detalle difMas(Long difMas) {
			if (difMas == null) this.message.remove("difMas");
			else this.message.set("difMas", difMas);
			return this;
		}

		public Detalle difMenos(Long difMenos) {
			if (difMenos == null) this.message.remove("difMenos");
			else this.message.set("difMenos", difMenos);
			return this;
		}

		public io.intino.alexandria.message.Message toMessage() {
			return this.message;
		}
	}

	@Override
	public io.intino.alexandria.message.Message toMessage() {

		return super.toMessage();
	}
}