package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ZonaSap {
	private static final java.util.Map<Integer, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category(0, "NA", "NA", "NA", "NA");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		try (java.io.BufferedReader reader = new java.io.BufferedReader(new java.io.InputStreamReader(ZonaSap.class.getResourceAsStream("/io/provista/datahub/zonasSap.tsv")))) {
			reader.lines().map(l -> l.split("\t", -1)).
			map(l -> new Category(l.length > 0 ? Integer.parseInt(l[0]) : -1, l.length > 1 ? l[1] : "NA", l.length > 2 ? l[2] : "NA", l.length > 3 ? l[3] : "NA", l.length > 4 ? l[4] : "NA")).
			forEach(w -> {categories.put(w.index, w); categoriesByName.put(w.name, w);});
		} catch (java.io.IOException e) {
			io.intino.alexandria.logger.Logger.error(e);
		}
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(int index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static Category categoryByClaveSap(String claveSap) {
		return categories.values().stream().filter(c -> c.claveSap.equals(claveSap)).findFirst().orElse(NA);
	}

	public static Category categoryByDivision(String division) {
		return categories.values().stream().filter(c -> c.division.equals(division)).findFirst().orElse(NA);
	}

	public static class Category {
		public final int index;
		public final String name;
		public final String label;
		public final String claveSap;
		public final String division;

		Category(int index, String name, String label, String claveSap, String division) {
			this.index = index;
			this.name = name;
			this.label = label;
			this.claveSap = claveSap;
			this.division = division;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}