package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TarifaRegulada {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category Apbt = new Category((short) 1, "apbt", "APBT");
	public static final Category Apmt = new Category((short) 2, "apmt", "APMT");
	public static final Category Db1 = new Category((short) 3, "db1", "DB1");
	public static final Category Db2 = new Category((short) 4, "db2", "DB2");
	public static final Category Dist = new Category((short) 5, "dist", "DIST");
	public static final Category Dit = new Category((short) 6, "dit", "DIT");
	public static final Category Gdbt = new Category((short) 7, "gdbt", "GDBT");
	public static final Category Gdmth = new Category((short) 8, "gdmth", "GDMTH");
	public static final Category Gdmto = new Category((short) 9, "gdmto", "GDMTO");
	public static final Category Pdbt = new Category((short) 10, "pdbt", "PDBT");
	public static final Category Rabt = new Category((short) 11, "rabt", "RABT");
	public static final Category Ramt = new Category((short) 12, "ramt", "RAMT");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, Apbt);
		categoriesByName.put("apbt", Apbt);
		categories.put((short) 2, Apmt);
		categoriesByName.put("apmt", Apmt);
		categories.put((short) 3, Db1);
		categoriesByName.put("db1", Db1);
		categories.put((short) 4, Db2);
		categoriesByName.put("db2", Db2);
		categories.put((short) 5, Dist);
		categoriesByName.put("dist", Dist);
		categories.put((short) 6, Dit);
		categoriesByName.put("dit", Dit);
		categories.put((short) 7, Gdbt);
		categoriesByName.put("gdbt", Gdbt);
		categories.put((short) 8, Gdmth);
		categoriesByName.put("gdmth", Gdmth);
		categories.put((short) 9, Gdmto);
		categoriesByName.put("gdmto", Gdmto);
		categories.put((short) 10, Pdbt);
		categoriesByName.put("pdbt", Pdbt);
		categories.put((short) 11, Rabt);
		categoriesByName.put("rabt", Rabt);
		categories.put((short) 12, Ramt);
		categoriesByName.put("ramt", Ramt);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}