package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Tarifa {
	private static final java.util.Map<Integer, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category(0, "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		try (java.io.BufferedReader reader = new java.io.BufferedReader(new java.io.InputStreamReader(Tarifa.class.getResourceAsStream("/io/provista/datahub/tarifas.tsv")))) {
			reader.lines().map(l -> l.split("\t", -1)).
			map(l -> new Category(l.length > 0 ? Integer.parseInt(l[0]) : -1, l.length > 1 ? l[1] : "NA", l.length > 2 ? l[2] : "NA", l.length > 3 ? l[3] : "NA", l.length > 4 ? l[4] : "NA", l.length > 5 ? l[5] : "NA", l.length > 6 ? l[6] : "NA", l.length > 7 ? l[7] : "NA", l.length > 8 ? l[8] : "NA", l.length > 9 ? l[9] : "NA")).
			forEach(w -> {categories.put(w.index, w); categoriesByName.put(w.name, w);});
		} catch (java.io.IOException e) {
			io.intino.alexandria.logger.Logger.error(e);
		}
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(int index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByTarifaSicom(String tarifaSicom) {
		return categories.values().stream().filter(c -> c.tarifaSicom.equals(tarifaSicom)).findFirst().orElse(NA);
	}

	public static Category categoryByNameTarifaSicom(String nameTarifaSicom) {
		return categories.values().stream().filter(c -> c.nameTarifaSicom.equals(nameTarifaSicom)).findFirst().orElse(NA);
	}

	public static Category categoryByTarifaRegulada(String tarifaRegulada) {
		return categories.values().stream().filter(c -> c.tarifaRegulada.equals(tarifaRegulada)).findFirst().orElse(NA);
	}

	public static Category categoryByNameTarifaRegulada(String nameTarifaRegulada) {
		return categories.values().stream().filter(c -> c.nameTarifaRegulada.equals(nameTarifaRegulada)).findFirst().orElse(NA);
	}

	public static Category categoryBySector(String sector) {
		return categories.values().stream().filter(c -> c.sector.equals(sector)).findFirst().orElse(NA);
	}

	public static Category categoryByEsHoraria(String esHoraria) {
		return categories.values().stream().filter(c -> c.esHoraria.equals(esHoraria)).findFirst().orElse(NA);
	}

	public static Category categoryByDemanda(String demanda) {
		return categories.values().stream().filter(c -> c.demanda.equals(demanda)).findFirst().orElse(NA);
	}

	public static Category categoryByTension(String tension) {
		return categories.values().stream().filter(c -> c.tension.equals(tension)).findFirst().orElse(NA);
	}

	public static class Category {
		public final int index;
		public final String name;
		public final String tarifaSicom;
		public final String nameTarifaSicom;
		public final String tarifaRegulada;
		public final String nameTarifaRegulada;
		public final String sector;
		public final String esHoraria;
		public final String demanda;
		public final String tension;

		Category(int index, String name, String tarifaSicom, String nameTarifaSicom, String tarifaRegulada, String nameTarifaRegulada, String sector, String esHoraria, String demanda, String tension) {
			this.index = index;
			this.name = name;
			this.tarifaSicom = tarifaSicom;
			this.nameTarifaSicom = nameTarifaSicom;
			this.tarifaRegulada = tarifaRegulada;
			this.nameTarifaRegulada = nameTarifaRegulada;
			this.sector = sector;
			this.esHoraria = esHoraria;
			this.demanda = demanda;
			this.tension = tension;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}