package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Suministradora {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category SuministroBasico = new Category((short) 1, "suministroBasico", "SUMINISTRO BASICO");
	public static final Category Calificados = new Category((short) 2, "calificados", "CALIFICADOS");
	public static final Category Sumex = new Category((short) 3, "sumex", "SUMEX");
	public static final Category IberdrolaClientes = new Category((short) 4, "iberdrolaClientes", "IBERDROLA CLIENTES");
	public static final Category OrcaEnergy = new Category((short) 5, "orcaEnergy", "ORCA ENERGY");
	public static final Category Fenix = new Category((short) 6, "fenix", "FENIX");
	public static final Category Frontera = new Category((short) 7, "frontera", "FRONTERA");
	public static final Category GeneracionI = new Category((short) 8, "generacionI", "SUBSIDIARIA GENERACION I");
	public static final Category GeneracionII = new Category((short) 9, "generacionII", "SUBSIDIARIA GENERACION II");
	public static final Category GeneracionIV = new Category((short) 10, "generacionIV", "SUBSIDIARIA GENERACION IV");
	public static final Category GeneracionVI = new Category((short) 11, "generacionVI", "SUBSIDIARIA GENERACION VI");
	public static final Category Elan = new Category((short) 12, "elan", "ELAN");
	public static final Category Icl = new Category((short) 13, "icl", "ICL");
	public static final Category Ammper = new Category((short) 14, "ammper", "AMMPER");
	public static final Category FseFenix = new Category((short) 15, "fseFenix", "FSE FENIX");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, SuministroBasico);
		categoriesByName.put("suministroBasico", SuministroBasico);
		categories.put((short) 2, Calificados);
		categoriesByName.put("calificados", Calificados);
		categories.put((short) 3, Sumex);
		categoriesByName.put("sumex", Sumex);
		categories.put((short) 4, IberdrolaClientes);
		categoriesByName.put("iberdrolaClientes", IberdrolaClientes);
		categories.put((short) 5, OrcaEnergy);
		categoriesByName.put("orcaEnergy", OrcaEnergy);
		categories.put((short) 6, Fenix);
		categoriesByName.put("fenix", Fenix);
		categories.put((short) 7, Frontera);
		categoriesByName.put("frontera", Frontera);
		categories.put((short) 8, GeneracionI);
		categoriesByName.put("generacionI", GeneracionI);
		categories.put((short) 9, GeneracionII);
		categoriesByName.put("generacionII", GeneracionII);
		categories.put((short) 10, GeneracionIV);
		categoriesByName.put("generacionIV", GeneracionIV);
		categories.put((short) 11, GeneracionVI);
		categoriesByName.put("generacionVI", GeneracionVI);
		categories.put((short) 12, Elan);
		categoriesByName.put("elan", Elan);
		categories.put((short) 13, Icl);
		categoriesByName.put("icl", Icl);
		categories.put((short) 14, Ammper);
		categoriesByName.put("ammper", Ammper);
		categories.put((short) 15, FseFenix);
		categoriesByName.put("fseFenix", FseFenix);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}