package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SegmentoSocioeconomico {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category Bajo = new Category((short) 1, "bajo", "BAJO");
	public static final Category MedioBajo = new Category((short) 2, "medioBajo", "MEDIO BAJO");
	public static final Category MedioAlto = new Category((short) 3, "medioAlto", "MEDIO ALTO");
	public static final Category Alto = new Category((short) 4, "alto", "ALTO");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, Bajo);
		categoriesByName.put("bajo", Bajo);
		categories.put((short) 2, MedioBajo);
		categoriesByName.put("medioBajo", MedioBajo);
		categories.put((short) 3, MedioAlto);
		categoriesByName.put("medioAlto", MedioAlto);
		categories.put((short) 4, Alto);
		categoriesByName.put("alto", Alto);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}