package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SegmentoComercial {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category DomesticoMasivo = new Category((short) 1, "domesticoMasivo", "DOMESTICO MASIVO");
	public static final Category DomesticoDac = new Category((short) 2, "domesticoDac", "DOMESTICO DAC");
	public static final Category DomesticoMultiservicios = new Category((short) 3, "domesticoMultiservicios", "DOMESTICO MULTISERVICIOS");
	public static final Category DomesticoAltoPotencial = new Category((short) 4, "domesticoAltoPotencial", "DOMESTICO ALTO POTENCIAL");
	public static final Category NoDomesticoMasivo = new Category((short) 5, "noDomesticoMasivo", "NO DOMESTICO MASIVO");
	public static final Category NoDomesticoServicioPublico = new Category((short) 6, "noDomesticoServicioPublico", "NO DOMESTICO SERVICIO PÚBLICO");
	public static final Category NoDomesticoEmpresaConliquidez = new Category((short) 7, "noDomesticoEmpresaConliquidez", "NO DOMESTICO EMPRESA CON LIQUIDEZ");
	public static final Category NoDomesticoMultiservicios = new Category((short) 8, "noDomesticoMultiservicios", "NO DOMESTICO MULTISERVICIOS");
	public static final Category NoDomesticoAltoValor = new Category((short) 9, "noDomesticoAltoValor", "NO DOMESTICO ALTO VALOR");
	public static final Category NoDomesticoCalificables = new Category((short) 10, "noDomesticoCalificables", "NO DOMESTICO CALIFICABLES");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, DomesticoMasivo);
		categoriesByName.put("domesticoMasivo", DomesticoMasivo);
		categories.put((short) 2, DomesticoDac);
		categoriesByName.put("domesticoDac", DomesticoDac);
		categories.put((short) 3, DomesticoMultiservicios);
		categoriesByName.put("domesticoMultiservicios", DomesticoMultiservicios);
		categories.put((short) 4, DomesticoAltoPotencial);
		categoriesByName.put("domesticoAltoPotencial", DomesticoAltoPotencial);
		categories.put((short) 5, NoDomesticoMasivo);
		categoriesByName.put("noDomesticoMasivo", NoDomesticoMasivo);
		categories.put((short) 6, NoDomesticoServicioPublico);
		categoriesByName.put("noDomesticoServicioPublico", NoDomesticoServicioPublico);
		categories.put((short) 7, NoDomesticoEmpresaConliquidez);
		categoriesByName.put("noDomesticoEmpresaConliquidez", NoDomesticoEmpresaConliquidez);
		categories.put((short) 8, NoDomesticoMultiservicios);
		categoriesByName.put("noDomesticoMultiservicios", NoDomesticoMultiservicios);
		categories.put((short) 9, NoDomesticoAltoValor);
		categoriesByName.put("noDomesticoAltoValor", NoDomesticoAltoValor);
		categories.put((short) 10, NoDomesticoCalificables);
		categoriesByName.put("noDomesticoCalificables", NoDomesticoCalificables);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}