package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Municipio {
	private static final java.util.Map<Integer, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category(0, "NA", "NA", "NA", "NA", "NA", "NA", "NA", "NA");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		try (java.io.BufferedReader reader = new java.io.BufferedReader(new java.io.InputStreamReader(Municipio.class.getResourceAsStream("/io/provista/datahub/municipios.tsv")))) {
			reader.lines().map(l -> l.split("\t", -1)).
			map(l -> new Category(l.length > 0 ? Integer.parseInt(l[0]) : -1, l.length > 1 ? l[1] : "NA", l.length > 2 ? l[2] : "NA", l.length > 3 ? l[3] : "NA", l.length > 4 ? l[4] : "NA", l.length > 5 ? l[5] : "NA", l.length > 6 ? l[6] : "NA", l.length > 7 ? l[7] : "NA", l.length > 8 ? l[8] : "NA")).
			forEach(w -> {categories.put(w.index, w); categoriesByName.put(w.name, w);});
		} catch (java.io.IOException e) {
			io.intino.alexandria.logger.Logger.error(e);
		}
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(int index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByRfc(String rfc) {
		return categories.values().stream().filter(c -> c.rfc.equals(rfc)).findFirst().orElse(NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static Category categoryByDireccion(String direccion) {
		return categories.values().stream().filter(c -> c.direccion.equals(direccion)).findFirst().orElse(NA);
	}

	public static Category categoryByCodigoPostal(String codigoPostal) {
		return categories.values().stream().filter(c -> c.codigoPostal.equals(codigoPostal)).findFirst().orElse(NA);
	}

	public static Category categoryByEstado(String estado) {
		return categories.values().stream().filter(c -> c.estado.equals(estado)).findFirst().orElse(NA);
	}

	public static Category categoryByPais(String pais) {
		return categories.values().stream().filter(c -> c.pais.equals(pais)).findFirst().orElse(NA);
	}

	public static Category categoryByCodigoInegi(String codigoInegi) {
		return categories.values().stream().filter(c -> c.codigoInegi.equals(codigoInegi)).findFirst().orElse(NA);
	}

	public static class Category {
		public final int index;
		public final String name;
		public final String rfc;
		public final String label;
		public final String direccion;
		public final String codigoPostal;
		public final String estado;
		public final String pais;
		public final String codigoInegi;

		Category(int index, String name, String rfc, String label, String direccion, String codigoPostal, String estado, String pais, String codigoInegi) {
			this.index = index;
			this.name = name;
			this.rfc = rfc;
			this.label = label;
			this.direccion = direccion;
			this.codigoPostal = codigoPostal;
			this.estado = estado;
			this.pais = pais;
			this.codigoInegi = codigoInegi;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}