package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ModoPago {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category Efectivo = new Category((short) 1, "efectivo", "EFECTIVO");
	public static final Category TarjetaCredito = new Category((short) 2, "tarjetaCredito", "TARJETA DE CREDITO");
	public static final Category TarjetaPrepago = new Category((short) 3, "tarjetaPrepago", "TARJETA PREPAGO");
	public static final Category Transferencia = new Category((short) 4, "transferencia", "TRANSFERENCIA");
	public static final Category Domiciliacion = new Category((short) 5, "domiciliacion", "DOMICILIACION");
	public static final Category Cheque = new Category((short) 6, "cheque", "CHEQUE");
	public static final Category Convenio = new Category((short) 7, "convenio", "CONVENIO");
	public static final Category AplicacionDap = new Category((short) 8, "aplicacionDap", "APLICACION DE DAP");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, Efectivo);
		categoriesByName.put("efectivo", Efectivo);
		categories.put((short) 2, TarjetaCredito);
		categoriesByName.put("tarjetaCredito", TarjetaCredito);
		categories.put((short) 3, TarjetaPrepago);
		categoriesByName.put("tarjetaPrepago", TarjetaPrepago);
		categories.put((short) 4, Transferencia);
		categoriesByName.put("transferencia", Transferencia);
		categories.put((short) 5, Domiciliacion);
		categoriesByName.put("domiciliacion", Domiciliacion);
		categories.put((short) 6, Cheque);
		categoriesByName.put("cheque", Cheque);
		categories.put((short) 7, Convenio);
		categoriesByName.put("convenio", Convenio);
		categories.put((short) 8, AplicacionDap);
		categoriesByName.put("aplicacionDap", AplicacionDap);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}