package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EstatusContrato {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category Activo = new Category((short) 1, "activo", "ACTIVO");
	public static final Category Baja = new Category((short) 2, "baja", "BAJA");
	public static final Category Cortado = new Category((short) 4, "cortado", "CORTADO");
	public static final Category Desconectado = new Category((short) 5, "desconectado", "DESCONECTADO");
	public static final Category SujetoACorte = new Category((short) 6, "sujetoACorte", "SUJETO A CORTE");
	public static final Category CortadoAroCand = new Category((short) 7, "CortadoAroCand", "CORTADO ARO CANDADO");
	public static final Category Temporal = new Category((short) 8, "temporal", "TEMPORAL");
	public static final Category BajaSinMedidorRet = new Category((short) 9, "bajaSinMedidorRet", "BAJA SIN MEDIDOR RETIRADO");
	public static final Category CorteMufaPoste = new Category((short) 10, "corteMufaPoste", "CORTE MUFA POSTE");
	public static final Category BajaEnProceso = new Category((short) 11, "bajaEnProceso", "BAJA EN PROCESO");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, Activo);
		categoriesByName.put("activo", Activo);
		categories.put((short) 2, Baja);
		categoriesByName.put("baja", Baja);
		categories.put((short) 4, Cortado);
		categoriesByName.put("cortado", Cortado);
		categories.put((short) 5, Desconectado);
		categoriesByName.put("desconectado", Desconectado);
		categories.put((short) 6, SujetoACorte);
		categoriesByName.put("sujetoACorte", SujetoACorte);
		categories.put((short) 7, CortadoAroCand);
		categoriesByName.put("CortadoAroCand", CortadoAroCand);
		categories.put((short) 8, Temporal);
		categoriesByName.put("temporal", Temporal);
		categories.put((short) 9, BajaSinMedidorRet);
		categoriesByName.put("bajaSinMedidorRet", BajaSinMedidorRet);
		categories.put((short) 10, CorteMufaPoste);
		categoriesByName.put("corteMufaPoste", CorteMufaPoste);
		categories.put((short) 11, BajaEnProceso);
		categoriesByName.put("bajaEnProceso", BajaEnProceso);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}