package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClasePeriodoVerano {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category FebJul = new Category((short) 1, "febJul", "1 FEB - 31 JUL");
	public static final Category MarAgo = new Category((short) 2, "marAgo", "1 MAR - 31 AGO");
	public static final Category AbrSep = new Category((short) 3, "abrSep", "1 ABR - 30 SEP");
	public static final Category MayOct = new Category((short) 4, "mayOct", "1 MAY - 31 OCT");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, FebJul);
		categoriesByName.put("febJul", FebJul);
		categories.put((short) 2, MarAgo);
		categoriesByName.put("marAgo", MarAgo);
		categories.put((short) 3, AbrSep);
		categoriesByName.put("abrSep", AbrSep);
		categories.put((short) 4, MayOct);
		categoriesByName.put("mayOct", MayOct);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}