package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClasePeriodo {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category Base = new Category((short) 1, "base", "BASE");
	public static final Category Semipunta = new Category((short) 2, "semipunta", "SEMIPUNTA");
	public static final Category Punta = new Category((short) 3, "punta", "PUNTA");
	public static final Category Intermedio = new Category((short) 4, "intermedio", "INTERMEDIO");
	public static final Category Diurna = new Category((short) 5, "diurna", "DIURNA");
	public static final Category Nocturna = new Category((short) 6, "nocturna", "NOCTURNA");
	public static final Category Indefinida = new Category((short) 7, "indefinida", "INDEFINIDA");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, Base);
		categoriesByName.put("base", Base);
		categories.put((short) 2, Semipunta);
		categoriesByName.put("semipunta", Semipunta);
		categories.put((short) 3, Punta);
		categoriesByName.put("punta", Punta);
		categories.put((short) 4, Intermedio);
		categoriesByName.put("intermedio", Intermedio);
		categories.put((short) 5, Diurna);
		categoriesByName.put("diurna", Diurna);
		categories.put((short) 6, Nocturna);
		categoriesByName.put("nocturna", Nocturna);
		categories.put((short) 7, Indefinida);
		categoriesByName.put("indefinida", Indefinida);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}