package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClaseGiro {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category Publico = new Category((short) 1, "publico", "PÚBLICO");
	public static final Category Federal = new Category((short) 2, "federal", "FEDERAL");
	public static final Category Municipal = new Category((short) 3, "municipal", "MUNICIPAL");
	public static final Category Estatal = new Category((short) 4, "estatal", "ESTATAL");
	public static final Category ParaEstatal = new Category((short) 5, "paraEstatal", "PARAESTATAL");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, Publico);
		categoriesByName.put("publico", Publico);
		categories.put((short) 2, Federal);
		categoriesByName.put("federal", Federal);
		categories.put((short) 3, Municipal);
		categoriesByName.put("municipal", Municipal);
		categories.put((short) 4, Estatal);
		categoriesByName.put("estatal", Estatal);
		categories.put((short) 5, ParaEstatal);
		categoriesByName.put("paraEstatal", ParaEstatal);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}