package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClaseGestion {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category SinAreaConflicto = new Category((short) 1, "sinAreaConflicto", "SIN AREA DE CONFLICTO");
	public static final Category AdiosDeuda = new Category((short) 2, "adiosDeuda", "ADIOS A TU DEUDA");
	public static final Category AreaConflicto = new Category((short) 3, "areaConflicto", "AREA DE CONFLICTO");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, SinAreaConflicto);
		categoriesByName.put("sinAreaConflicto", SinAreaConflicto);
		categories.put((short) 2, AdiosDeuda);
		categoriesByName.put("adiosDeuda", AdiosDeuda);
		categories.put((short) 3, AreaConflicto);
		categoriesByName.put("areaConflicto", AreaConflicto);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}