package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClaseFacturacion {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category Mensual = new Category((short) 1, "mensual", "MENSUAL");
	public static final Category Bimestral = new Category((short) 2, "bimestral", "BIMESTRAL");
	public static final Category Tetramestral = new Category((short) 3, "tetramestral", "TETRAMESTRAL");
	public static final Category SoloTemporal = new Category((short) 4, "soloTemporal", "SOLO TEMPORAL");
	public static final Category CicloEspecial = new Category((short) 5, "cicloEspecial", "CICLO ESPECIAL");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, Mensual);
		categoriesByName.put("mensual", Mensual);
		categories.put((short) 2, Bimestral);
		categoriesByName.put("bimestral", Bimestral);
		categories.put((short) 3, Tetramestral);
		categoriesByName.put("tetramestral", Tetramestral);
		categories.put((short) 4, SoloTemporal);
		categoriesByName.put("soloTemporal", SoloTemporal);
		categories.put((short) 5, CicloEspecial);
		categoriesByName.put("cicloEspecial", CicloEspecial);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}