package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClaseExencion {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category CCR = new Category((short) 1, "CCR", "CORPORATIVO RECONOCIDO");
	public static final Category CDI = new Category((short) 2, "CDI", "DISTRIBUCIÓN");
	public static final Category CG1 = new Category((short) 3, "CG1", "GENERACIÓN I RECONOCIDO");
	public static final Category CG2 = new Category((short) 4, "CG2", "GENERACIÓN II");
	public static final Category CG3 = new Category((short) 5, "CG3", "GENERACIÓN III");
	public static final Category CG4 = new Category((short) 6, "CG4", "GENERACIÓN IV");
	public static final Category CG6 = new Category((short) 7, "CG6", "GENERACIÓN VI");
	public static final Category SSB = new Category((short) 8, "SSB", "SUMINISTRO BÁSICO");
	public static final Category CMT = new Category((short) 9, "CMT", "TRANSMISIÓN");
	public static final Category USG = new Category((short) 10, "USG", "USGA CORPORATIVO");
	public static final Category CME = new Category((short) 11, "CME", "EMPLEADOS");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, CCR);
		categoriesByName.put("CCR", CCR);
		categories.put((short) 2, CDI);
		categoriesByName.put("CDI", CDI);
		categories.put((short) 3, CG1);
		categoriesByName.put("CG1", CG1);
		categories.put((short) 4, CG2);
		categoriesByName.put("CG2", CG2);
		categories.put((short) 5, CG3);
		categoriesByName.put("CG3", CG3);
		categories.put((short) 6, CG4);
		categoriesByName.put("CG4", CG4);
		categories.put((short) 7, CG6);
		categoriesByName.put("CG6", CG6);
		categories.put((short) 8, SSB);
		categoriesByName.put("SSB", SSB);
		categories.put((short) 9, CMT);
		categoriesByName.put("CMT", CMT);
		categories.put((short) 10, USG);
		categoriesByName.put("USG", USG);
		categories.put((short) 11, CME);
		categoriesByName.put("CME", CME);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}