package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClaseEmpresa {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category Cenac = new Category((short) 1, "cenac", "CENAC");
	public static final Category Dci = new Category((short) 2, "dci", "DCIPI");
	public static final Category DireccionOperaciones = new Category((short) 3, "direccionOperaciones", "DIRECCION OPERACIONES");
	public static final Category Distribucion = new Category((short) 4, "distribucion", "DISTRIBUCION");
	public static final Category Generacion1 = new Category((short) 5, "generacion1", "GENERACION I");
	public static final Category Generacion2 = new Category((short) 6, "generacion2", "GENERACION II");
	public static final Category Generacion3 = new Category((short) 7, "generacion3", "GENERACION III");
	public static final Category Generacion4 = new Category((short) 8, "generacion4", "GENERACION IV");
	public static final Category Generacion5 = new Category((short) 9, "generacion5", "GENERACION V");
	public static final Category Generacion6 = new Category((short) 10, "generacion6", "GENERACION VI");
	public static final Category SuministroBasico = new Category((short) 11, "suministroBasico", "SUMINISTRO BASICO");
	public static final Category Transmision = new Category((short) 12, "transmision", "TRANSMISION");
	public static final Category UsgaCorporativo = new Category((short) 13, "usgaCorporativo", "USGA CORPORATIVO");
	public static final Category Empleados = new Category((short) 14, "empleados", "EMPLEADOS");
	public static final Category TelecomInternetTodos = new Category((short) 15, "telecomInternetTodos", "TELECOMINTERNETTODOS");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, Cenac);
		categoriesByName.put("cenac", Cenac);
		categories.put((short) 2, Dci);
		categoriesByName.put("dci", Dci);
		categories.put((short) 3, DireccionOperaciones);
		categoriesByName.put("direccionOperaciones", DireccionOperaciones);
		categories.put((short) 4, Distribucion);
		categoriesByName.put("distribucion", Distribucion);
		categories.put((short) 5, Generacion1);
		categoriesByName.put("generacion1", Generacion1);
		categories.put((short) 6, Generacion2);
		categoriesByName.put("generacion2", Generacion2);
		categories.put((short) 7, Generacion3);
		categoriesByName.put("generacion3", Generacion3);
		categories.put((short) 8, Generacion4);
		categoriesByName.put("generacion4", Generacion4);
		categories.put((short) 9, Generacion5);
		categoriesByName.put("generacion5", Generacion5);
		categories.put((short) 10, Generacion6);
		categoriesByName.put("generacion6", Generacion6);
		categories.put((short) 11, SuministroBasico);
		categoriesByName.put("suministroBasico", SuministroBasico);
		categories.put((short) 12, Transmision);
		categoriesByName.put("transmision", Transmision);
		categories.put((short) 13, UsgaCorporativo);
		categoriesByName.put("usgaCorporativo", UsgaCorporativo);
		categories.put((short) 14, Empleados);
		categoriesByName.put("empleados", Empleados);
		categories.put((short) 15, TelecomInternetTodos);
		categoriesByName.put("telecomInternetTodos", TelecomInternetTodos);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}