package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClaseCartera {
	private static final java.util.Map<Short, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category((short) 0, "NA");
	public static final Category Normal = new Category((short) 1, "normal", "CUENTAS POR COBRAR < 30 DÍAS");
	public static final Category Rezago = new Category((short) 2, "rezago", "REZAGO > 30 DIAS");
	public static final Category Documentada = new Category((short) 3, "documentada", "PAGARÉS");
	public static final Category Incobrable = new Category((short) 4, "incobrable", "INCOBRABLE");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		categories.put((short) 1, Normal);
		categoriesByName.put("normal", Normal);
		categories.put((short) 2, Rezago);
		categoriesByName.put("rezago", Rezago);
		categories.put((short) 3, Documentada);
		categoriesByName.put("documentada", Documentada);
		categories.put((short) 4, Incobrable);
		categoriesByName.put("incobrable", Incobrable);
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(short index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static class Category {
		public final short index;
		public final String name;
		public final String label;

		Category(short index, String name) {
			this(index, name, name);
		}

		Category(short index, String name, String label) {
			this.index = index;
			this.name = name;
			this.label = label;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}