package io.provista.datahub.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Agencia {
	private static final java.util.Map<Integer, Category> categories;
	private static final java.util.Map<String, Category> categoriesByName;
	public static final Category NA = new Category(0, "NA", "NA", "NA", "NA", "NA");
	static {
		categories = new java.util.HashMap<>();
		categoriesByName = new java.util.HashMap<>();
		try (java.io.BufferedReader reader = new java.io.BufferedReader(new java.io.InputStreamReader(Agencia.class.getResourceAsStream("/io/provista/datahub/agencias.tsv")))) {
			reader.lines().map(l -> l.split("\t", -1)).
			map(l -> new Category(l.length > 0 ? Integer.parseInt(l[0]) : -1, l.length > 1 ? l[1] : "NA", l.length > 2 ? l[2] : "NA", l.length > 3 ? l[3] : "NA", l.length > 4 ? l[4] : "NA", l.length > 5 ? l[5] : "NA")).
			forEach(w -> {categories.put(w.index, w); categoriesByName.put(w.name, w);});
		} catch (java.io.IOException e) {
			io.intino.alexandria.logger.Logger.error(e);
		}
	}

	public static List<Category> categories() {
		return new ArrayList<>(categories.values());
	}

	public static List<Category> categories(Predicate<Category> filter) {
		return categories.values().stream().filter(filter).collect(Collectors.toList());
	}

	public static Category categoryByIndex(int index) {
		return categories.getOrDefault(index, NA);
	}

	public static Category categoryByName(String name) {
		return categoriesByName.getOrDefault(name, NA);
	}

	public static Category categoryByCentroCosto(String centroCosto) {
		return categories.values().stream().filter(c -> c.centroCosto.equals(centroCosto)).findFirst().orElse(NA);
	}

	public static Category categoryByLabel(String label) {
		return categories.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);
	}

	public static Category categoryByDivision(String division) {
		return categories.values().stream().filter(c -> c.division.equals(division)).findFirst().orElse(NA);
	}

	public static Category categoryByZona(String zona) {
		return categories.values().stream().filter(c -> c.zona.equals(zona)).findFirst().orElse(NA);
	}

	public static class Category {
		public final int index;
		public final String name;
		public final String centroCosto;
		public final String label;
		public final String division;
		public final String zona;

		Category(int index, String name, String centroCosto, String label, String division, String zona) {
			this.index = index;
			this.name = name;
			this.centroCosto = centroCosto;
			this.label = label;
			this.division = division;
			this.zona = zona;
		}

		public boolean equals(Category category) {
			return this.index == category.index;
		}
	}
}