/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.parser.antlr;

import io.intino.tara.Source;
import io.intino.tara.language.grammar.SyntaxException;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.language.grammar.TaraGrammarBaseListener;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.EmptyMogram;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.NamedReference;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import io.intino.tara.model.constraints.Constraint;
import io.intino.tara.model.rules.Size;
import io.intino.tara.model.rules.composition.ConstraintRule;
import io.intino.tara.model.rules.property.DateRule;
import io.intino.tara.model.rules.property.DoubleRule;
import io.intino.tara.model.rules.property.FunctionRule;
import io.intino.tara.model.rules.property.IntegerRule;
import io.intino.tara.model.rules.property.LongRule;
import io.intino.tara.model.rules.property.NativeObjectRule;
import io.intino.tara.model.rules.property.PropertyCustomRule;
import io.intino.tara.model.rules.property.ResourceRule;
import io.intino.tara.model.rules.property.StringRule;
import io.intino.tara.model.rules.property.TypeRule;
import io.intino.tara.model.rules.property.WordRule;
import io.intino.tara.processors.model.FacetConstraint;
import io.intino.tara.processors.model.FacetImpl;
import io.intino.tara.processors.model.HasMogram;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.model.MogramImpl;
import io.intino.tara.processors.model.PropertyImpl;
import io.intino.tara.processors.model.ReferenceProperty;
import io.intino.tara.processors.utils.Format;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ModelGenerator
extends TaraGrammarBaseListener {
    private final Deque<ElementContainer> deque = new ArrayDeque<ElementContainer>();
    private final Set<String> uses = new HashSet<String>();
    private final Model model;
    private final List<SyntaxException> errors = new ArrayList<SyntaxException>();
    private final String fileContent;
    private final Source source;

    public ModelGenerator(Source source) {
        this.source = source;
        try (InputStream content = source.content();){
            this.model = new Model(source.uri());
            this.deque.add(this.model);
            this.fileContent = new String(content.readAllBytes(), source.charset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void enterAnImport(TaraGrammar.AnImportContext ctx) {
        this.uses.add(ctx.headerReference().getText());
    }

    @Override
    public void enterDslDeclaration(TaraGrammar.DslDeclarationContext ctx) {
        if (ctx.headerReference() != null) {
            String langName = ctx.headerReference().getText();
            if (langName.isEmpty()) {
                this.addError("Language " + langName + " not found", ctx);
            }
        } else {
            this.addError("Language not found", ctx);
        }
    }

    private static ParserRuleContext nextSibling(ParserRuleContext ctx) {
        if (ctx == null || ctx.parent == null) {
            return null;
        }
        int index = ctx.getParent().children.indexOf(ctx);
        while (index < ctx.getParent().children.size() - 1) {
            ParseTree child;
            if (!((child = ctx.parent.getChild(++index)) instanceof ParserRuleContext)) continue;
            ParserRuleContext p = (ParserRuleContext)child;
            return p;
        }
        return null;
    }

    @Override
    public void enterMogram(TaraGrammar.MogramContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        try {
            int startIndex = ctx.getStart().getStartIndex();
            ParserRuleContext nextMogram = ModelGenerator.nextSibling(ctx);
            int endIndex = nextMogram != null ? nextMogram.getStart().getStartIndex() : ctx.getParent().getStop().getStopIndex();
            MogramImpl mogram = new MogramImpl(this.fileContent.substring(startIndex, endIndex), this.source.uri(), ctx.getStart().getLine(), this.textRange(ctx, nextMogram));
            String hashCodeName = this.calculateName(ctx);
            if (ctx.signature().IDENTIFIER() != null) {
                mogram.name(ctx.signature().IDENTIFIER().getText());
                mogram.anonymous(false);
            } else {
                mogram.name(hashCodeName);
            }
            mogram.setHashCode(hashCodeName);
            mogram.languageName(this.model.languageName());
            mogram.setSub(ctx.signature().SUB() != null);
            ElementContainer container = this.resolveContainer(mogram);
            mogram.container(container);
            container.add(mogram, this.rulesOf(this.mogramRules(ctx.signature().mogramConstraint())));
            this.facetTarget(ctx, mogram);
            if (!this.errors.isEmpty()) {
                return;
            }
            mogram.type(this.type(ctx, mogram));
            this.resolveParent(ctx, mogram);
            this.addAnnotations(ctx.signature().annotations(), mogram);
            mogram.addUses(new ArrayList<String>(this.uses));
            this.deque.push(mogram);
        }
        catch (Exception e) {
            this.errors.add(new SyntaxException("Syntax error. Unexpected tokens.", e, this.source.uri(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine()));
        }
    }

    private void facetTarget(TaraGrammar.MogramContext ctx, MogramImpl mogram) {
        if (ctx.signature().SUB() != null) {
            Mogram container = (Mogram)this.deque.peek();
            if (container.facetPrescription() != null && container.facetPrescription().resolved()) {
                mogram.facetPrescription(container.facetPrescription().get());
                mogram.facetPrescription().get().addApplicableFacet(mogram);
            } else if (container.facetPrescription() != null) {
                mogram.facetPrescription(container.facetPrescription().reference());
                mogram.facetPrescription().get().addApplicableFacet(mogram);
            }
        } else if (ctx.signature().FACET() != null) {
            ElementContainer container = mogram.container();
            if (container instanceof Model) {
                this.errors.add(new SyntaxException("'facet' declaration cannot be root", this.source.uri(), ctx.signature().getStart().getLine(), ctx.signature().getStart().getCharPositionInLine(), "Concept"));
                return;
            }
            if (ctx.signature().IDENTIFIER() == null) {
                this.errors.add(new SyntaxException("'facet' declaration must have name", this.source.uri(), ctx.signature().getStart().getLine(), ctx.signature().getStart().getCharPositionInLine(), ""));
                return;
            }
            mogram.facetPrescription((Mogram)container);
            mogram.facetPrescription().get().addApplicableFacet(mogram);
        } else if (ctx.signature().facetTarget() != null) {
            mogram.facetPrescription(ctx.signature().facetTarget().identifierReference().getText());
        }
    }

    private String type(TaraGrammar.MogramContext ctx, MogramImpl mogram) {
        if (mogram.isSub()) {
            return ((Mogram)this.deque.peek()).types().getFirst();
        }
        if (mogram.facetPrescription() != null && ctx.signature().FACET() != null) {
            return mogram.facetPrescription().get().types().getFirst();
        }
        return ctx.signature().metaidentifier().getText();
    }

    private String calculateName(TaraGrammar.MogramContext ctx) {
        int hashCode = ctx.getText().replace(" ", "").hashCode();
        String name = new File(this.source.uri().getPath()).getName();
        return (name.contains(".") ? name.substring(0, name.lastIndexOf(".")) : name) + "_" + ctx.getStart().getLine() + "_" + ctx.getStart().getCharPositionInLine() + "_" + (hashCode > 0 ? "0" + hashCode : "1" + Math.abs(hashCode));
    }

    private List<TaraGrammar.MogramConstraintContext> mogramRules(List<TaraGrammar.MogramConstraintContext> container) {
        ArrayList<TaraGrammar.MogramConstraintContext> contexts = new ArrayList<TaraGrammar.MogramConstraintContext>();
        if (container.isEmpty()) {
            return Collections.emptyList();
        }
        if (container.size() != 1) {
            return container;
        }
        contexts.add(container.getFirst());
        return contexts;
    }

    private List<Rule<?>> rulesOf(List<TaraGrammar.MogramConstraintContext> mogramConstraint) {
        if (mogramConstraint == null || mogramConstraint.isEmpty()) {
            return List.of(Size.MULTIPLE());
        }
        List<Rule<?>> collect = mogramConstraint.stream().map(context -> this.createRule(context.ruleValue())).collect(Collectors.toList());
        if (collect.stream().noneMatch(r -> r instanceof Size)) {
            collect.addFirst(Size.MULTIPLE());
        }
        return collect;
    }

    private Rule<?> createRule(TaraGrammar.RuleValueContext rule) {
        if (this.isCustom(rule)) {
            if (this.isBundledRule(rule.getText())) {
                return this.bundledRule(rule.getText());
            }
            return new ConstraintRule(new NamedReference<Constraint>(rule.getText()));
        }
        return this.processLambdaRule(rule);
    }

    private boolean isCustom(TaraGrammar.RuleValueContext isRule) {
        return isRule != null && isRule.LEFT_CURLY() == null;
    }

    private void addAnnotations(TaraGrammar.AnnotationsContext ctx, Mogram mogram) {
        if (ctx != null) {
            Annotation[] annotations = this.resolveAnnotations(ctx);
            if (annotations.length == 0) {
                this.errors.add(new SyntaxException("Expected an annotation", this.source.uri(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine(), Arrays.stream(Annotation.values()).map(Enum::name).collect(Collectors.joining(","))));
            }
            mogram.addAnnotations(annotations);
        }
    }

    private ElementContainer resolveContainer(Mogram mogram) {
        ElementContainer context = this.deque.peek();
        return mogram.isSub() ? context.container() : context;
    }

    private void resolveParent(TaraGrammar.MogramContext ctx, MogramImpl mogram) {
        if (mogram.isSub()) {
            Mogram peek = (Mogram)this.deque.peek();
            if (peek != null && !peek.is(Annotation.Generalization) && !peek.annotations().contains(Annotation.Generalization)) {
                peek.addAnnotations(Annotation.Generalization);
            }
            mogram.parent(peek);
            peek.addChild(mogram);
        } else {
            String parent = this.getParent(ctx);
            if (parent != null) {
                mogram.parent(parent);
            }
        }
    }

    private String getParent(TaraGrammar.MogramContext ctx) {
        if (ctx.signature().parent() == null) {
            return null;
        }
        TaraGrammar.IdentifierReferenceContext identifierReference = ctx.signature().parent().identifierReference();
        return identifierReference != null ? identifierReference.getText() : null;
    }

    @Override
    public void exitMogram(TaraGrammar.MogramContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        this.deque.pop();
    }

    @Override
    public void enterWith(TaraGrammar.WithContext ctx) {
        try {
            if (this.deque.peek() == null) {
                this.addError("Unavailable constraint 'with' in context " + this.deque.peek().getClass().getInterfaces()[0].getSimpleName(), ctx);
                return;
            }
            MogramImpl peek = (MogramImpl)this.deque.peek();
            peek.facetConstraints(this.collectConstrains(ctx.identifierReference()).stream().map(r -> new FacetConstraint((String)r, false, peek.source(), this.textRange(ctx))).collect(Collectors.toList()));
            super.enterWith(ctx);
        }
        catch (Exception e) {
            this.errors.add(new SyntaxException("Syntax error. Unexpected tokens.", e, this.source.uri(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine()));
        }
    }

    private List<String> collectConstrains(List<TaraGrammar.IdentifierReferenceContext> contexts) {
        return contexts.stream().map(RuleContext::getText).collect(Collectors.toList());
    }

    @Override
    public void enterFacet(TaraGrammar.FacetContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        if (this.deque.peek() == null) {
            this.addError("Unavailable component facet apply in context " + this.deque.peek().getClass().getInterfaces()[0].getSimpleName(), ctx);
            return;
        }
        try {
            Mogram current = (Mogram)this.deque.peek();
            FacetImpl facet = new FacetImpl(ctx.metaidentifier().getText(), current, this.source.uri(), ctx.getStart().getLine(), this.textRange(ctx));
            facet.languageName(this.model.languageName());
            current.applyFacet(facet);
        }
        catch (Exception e) {
            this.errors.add(new SyntaxException("Syntax error. Unexpected tokens.", e, this.source.uri(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine()));
        }
    }

    @Override
    public void enterDoc(TaraGrammar.DocContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        String doc = ctx.DOC().stream().map(d -> d.getText().substring(2)).collect(Collectors.joining()).trim();
        this.deque.peek().doc(doc);
    }

    @Override
    public void enterSignatureProperty(TaraGrammar.SignaturePropertyContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        try {
            int position = ((TaraGrammar.SignaturePropertiesContext)ctx.getParent()).signatureProperty().indexOf((Object)ctx);
            String metric = ctx.value().measureUnit() != null ? ctx.value().measureUnit().getText() : null;
            this.addParameter(ctx.IDENTIFIER() != null ? ctx.IDENTIFIER().getText() : "", this.facetOf(ctx), position, metric, this.resolveValue(ctx.value()), this.textRange(ctx));
        }
        catch (Exception e) {
            this.errors.add(new SyntaxException("Syntax error. Unexpected tokens.", e, this.source.uri(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine()));
        }
    }

    private String facetOf(TaraGrammar.SignaturePropertyContext ctx) {
        return ctx.getParent().getParent() instanceof TaraGrammar.FacetContext ? ((TaraGrammar.FacetContext)ctx.getParent().getParent()).metaidentifier().getText() : "";
    }

    private void addParameter(String name, String facet, int position, String measureValue, List<Object> values, Element.TextRange range) {
        ((Mogram)this.deque.peek()).addParameter(name, facet, position, measureValue, range, values);
    }

    @Override
    public void enterMogramReference(TaraGrammar.MogramReferenceContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        try {
            Mogram container = (Mogram)this.deque.peek();
            HasMogram mogramRef = new HasMogram(ctx.identifierReference().getText(), container.source(), ctx.getStart().getLine(), this.textRange(ctx));
            mogramRef.languageName(this.model.languageName());
            if (ctx.annotations() != null) {
                mogramRef.addAnnotations(this.resolveAnnotations(ctx.annotations()));
            }
            mogramRef.container(container);
            container.add(mogramRef, this.rulesOf(ctx.mogramConstraint() != null ? this.mogramRules(ctx.mogramConstraint()) : Collections.emptyList()));
        }
        catch (Exception e) {
            this.errors.add(new SyntaxException("Syntax error. Unexpected tokens.", e, this.source.uri(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine()));
        }
    }

    private Annotation[] resolveAnnotations(TaraGrammar.AnnotationsContext annotations) {
        return annotations == null ? new Annotation[]{} : (Annotation[])annotations.annotation().stream().map(a -> Annotation.valueOf(Format.capitalize(a.getText()))).toArray(Annotation[]::new);
    }

    @Override
    public void enterProperty(TaraGrammar.PropertyContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        try {
            Rule<?> rule;
            Mogram container = (Mogram)this.deque.peek();
            PropertyImpl property = this.createProperty(ctx, container);
            property.languageName(this.model.languageName());
            this.addValue(property, ctx);
            Size size = this.createSize(ctx);
            if (!property.values().isEmpty()) {
                size = new Size(0, size.max());
            }
            property.add(size);
            if (ctx.value() != null && ctx.value().measureUnit() != null) {
                property.metric(ctx.value().measureUnit().getText());
            }
            property.add(new TypeRule());
            if (ctx.mogramConstraint() != null) {
                property.add(this.createRule(property, ctx.mogramConstraint().ruleValue()));
            }
            if ((rule = property.type().defaultRule()) != null) {
                property.add(rule);
            }
            property.addAnnotations(this.resolveAnnotations(ctx.annotations()));
            container.add(property, property.rules());
        }
        catch (Exception e) {
            this.errors.add(new SyntaxException("Syntax error. Unexpected tokens.", e, this.source.uri(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine()));
        }
    }

    private Size createSize(TaraGrammar.PropertyContext context) {
        TaraGrammar.SizeContext sizeContext = context.size();
        if (sizeContext == null) {
            return Size.SINGLE_REQUIRED();
        }
        TaraGrammar.SizeRangeContext rangeContext = sizeContext.sizeRange();
        if (rangeContext == null) {
            return new Size(1, Integer.MAX_VALUE);
        }
        TaraGrammar.ListRangeContext listRange = rangeContext.listRange();
        if (listRange != null) {
            return new Size(Integer.parseInt(((ParseTree)listRange.children.getFirst()).getText()), Integer.parseInt(((ParseTree)listRange.children.getLast()).getText()));
        }
        int minMax = Integer.parseInt(rangeContext.getText());
        return new Size(minMax, minMax);
    }

    private Rule<?> createRule(Property prop, TaraGrammar.RuleValueContext rule) {
        if (this.isCustom(rule)) {
            if (Primitive.FUNCTION.equals(prop.type())) {
                return new FunctionRule(rule.getText());
            }
            if (Primitive.OBJECT.equals(prop.type())) {
                return new NativeObjectRule(rule.getText());
            }
            return this.isBundledRule(rule.identifierReference().getText()) ? this.bundledRule(rule.identifierReference().getText()) : new PropertyCustomRule(rule.getText());
        }
        return this.processLambdaRule(prop, rule);
    }

    private boolean isBundledRule(String text) {
        try {
            Class.forName("io.intino.tara.model.rules.custom." + Format.firstUpperCase(text));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Rule<?> bundledRule(String rule) {
        try {
            return (Rule)Class.forName("io.intino.tara.model.rules.custom." + Format.firstUpperCase(rule)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private Rule<?> processLambdaRule(Property var, TaraGrammar.RuleValueContext rule) {
        List<ParseTree> params = rule.children.subList(1, rule.children.size() - 1);
        if (Primitive.DOUBLE.equals(var.type())) {
            return new DoubleRule(this.minOf(params), this.maxOf(params), this.metric(params));
        }
        if (Primitive.INTEGER.equals(var.type())) {
            return new IntegerRule(this.minOf(params).intValue(), this.maxOf(params).intValue(), this.metric(params));
        }
        if (Primitive.LONG.equals(var.type())) {
            return new LongRule(this.minOf(params).longValue(), this.maxOf(params).longValue(), this.metric(params));
        }
        if (Primitive.STRING.equals(var.type())) {
            this.createStringProperty(var, params);
        } else {
            if (Primitive.RESOURCE.equals(var.type())) {
                return new ResourceRule(this.valuesOf(params));
            }
            if (Primitive.FUNCTION.equals(var.type())) {
                return new FunctionRule(params.getFirst().getText());
            }
            if (Primitive.WORD.equals(var.type())) {
                return new WordRule(this.valuesOf(params));
            }
            if (Primitive.DATE.equals(var.type())) {
                return new DateRule();
            }
            if (Primitive.OBJECT.equals(var.type())) {
                return new NativeObjectRule(this.classFrom(params.getFirst().getText()));
            }
        }
        return null;
    }

    private String classFrom(String text) {
        return text.startsWith("\"") ? text.substring(1, text.length() - 1) : text;
    }

    private Rule<?> processLambdaRule(TaraGrammar.RuleValueContext isRule) {
        return isRule == null ? null : this.createMogramRule(isRule);
    }

    private Size createMogramRule(TaraGrammar.RuleValueContext rule) {
        List<ParseTree> params = rule.children.subList(1, rule.children.size() - 1);
        int min = this.minOf(params).intValue();
        if (min < 0) {
            this.addError("Array size cannot be negative", rule);
        }
        return new Size(min, this.maxOf(params).intValue());
    }

    private void createStringProperty(Property property, List<ParseTree> parameters) {
        String value = this.valueOf(parameters, TaraGrammar.StringValueContext.class);
        if (value.isEmpty()) {
            this.addError("Expected pattern rule", (ParserRuleContext)parameters.getFirst().getParent());
            return;
        }
        property.add(new StringRule(value.substring(1, value.length() - 1)));
    }

    private String metric(List<ParseTree> parameters) {
        for (ParseTree parameter : parameters) {
            if (!(parameter instanceof TerminalNode) && !(parameter instanceof TaraGrammar.MeasureUnitContext)) continue;
            return parameter.getText();
        }
        return "";
    }

    private List<String> valuesOf(List<ParseTree> parameters) {
        return parameters.stream().map(ParseTree::getText).collect(Collectors.toList());
    }

    private String valueOf(List<ParseTree> parameters, Class<? extends ParserRuleContext> aClass) {
        ParseTree value = parameters.stream().filter(aClass::isInstance).findFirst().orElse(null);
        return value == null ? "" : value.getText();
    }

    private Double minOf(List<ParseTree> parameters) {
        TaraGrammar.RangeContext range = parameters.stream().filter(TaraGrammar.RangeContext.class::isInstance).findFirst().orElse(null);
        if (range == null) {
            return Double.NEGATIVE_INFINITY;
        }
        String min = ((ParseTree)range.children.getFirst()).getText();
        return min.equals("*") ? Double.NEGATIVE_INFINITY : Double.parseDouble(min);
    }

    private Double maxOf(List<ParseTree> parameters) {
        TaraGrammar.RangeContext range = parameters.stream().filter(TaraGrammar.RangeContext.class::isInstance).findFirst().orElse(null);
        if (range == null) {
            return Double.POSITIVE_INFINITY;
        }
        String max = ((ParseTree)range.children.getLast()).getText();
        return max.equals("*") ? Double.POSITIVE_INFINITY : Double.parseDouble(max);
    }

    private PropertyImpl createProperty(TaraGrammar.PropertyContext ctx, Mogram container) {
        TaraGrammar.PropertyTypeContext propType = ctx.propertyType();
        return propType.identifierReference() != null ? new ReferenceProperty(container, propType.getText(), ctx.IDENTIFIER().getText(), ctx.getStart().getLine(), this.textRange(ctx)) : new PropertyImpl(container, Primitive.value(propType.getText()), ctx.IDENTIFIER().getText(), ctx.getStart().getLine(), this.textRange(ctx));
    }

    private void addValue(Property prop, TaraGrammar.PropertyContext ctx) {
        List<Object> values;
        if (ctx.value() == null && ctx.bodyValue() == null) {
            return;
        }
        List<Object> list = values = ctx.bodyValue() != null ? this.resolveValue(ctx.bodyValue()) : this.resolveValue(ctx.value());
        if (prop.type().equals(Primitive.DOUBLE) && !values.isEmpty() && values.getFirst() instanceof Integer) {
            values = values.stream().map(v -> (double)((Integer)v)).collect(Collectors.toList());
        }
        prop.values(values);
        if (ctx.value() != null && ctx.value().measureUnit() != null) {
            prop.metric(ctx.value().measureUnit().getText());
        }
    }

    @Override
    public void enterPropertyDescriptive(TaraGrammar.PropertyDescriptiveContext ctx) {
        if (!this.errors.isEmpty()) {
            return;
        }
        String extension = ctx.value() != null && ctx.value().measureUnit() != null ? ctx.value().measureUnit().getText() : null;
        this.addParameter(ctx.IDENTIFIER().getText(), "", -1, extension, ctx.bodyValue() != null ? this.resolveValue(ctx.bodyValue()) : this.resolveValue(ctx.value()), this.textRange(ctx));
    }

    private List<Object> resolveValue(TaraGrammar.ValueContext ctx) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (!ctx.booleanValue().isEmpty()) {
            values.addAll(ctx.booleanValue().stream().map(context -> Primitive.BOOLEAN.convert(context.getText()).getFirst()).toList());
        } else if (!ctx.integerValue().isEmpty()) {
            values.addAll(ctx.integerValue().stream().map(context -> {
                try {
                    return Primitive.INTEGER.convert(context.getText()).getFirst();
                }
                catch (NumberFormatException e) {
                    return Primitive.LONG.convert(context.getText()).getFirst();
                }
            }).toList());
        } else if (!ctx.doubleValue().isEmpty()) {
            values.addAll(ctx.doubleValue().stream().map(context -> Primitive.DOUBLE.convert(context.getText()).getFirst()).toList());
        } else if (!ctx.tupleValue().isEmpty()) {
            values.addAll(ctx.tupleValue().stream().map(context -> new AbstractMap.SimpleEntry(context.stringValue().getText(), Primitive.DOUBLE.convert(context.doubleValue().getText()).getFirst())).toList());
        } else if (!ctx.stringValue().isEmpty()) {
            values.addAll(ctx.stringValue().stream().map(context -> this.formatString(context.getText())).toList());
        } else if (!ctx.identifierReference().isEmpty()) {
            values.addAll(ctx.identifierReference().stream().map(context -> new Primitive.Reference(context.getText())).toList());
        } else if (!ctx.methodReference().isEmpty()) {
            values.addAll(ctx.methodReference().stream().map(context -> new Primitive.MethodReference(context.getText().substring(1))).toList());
        } else if (!ctx.expression().isEmpty()) {
            values.addAll(ctx.expression().stream().map(context -> new Primitive.Expression(this.formatExpression(context.getText()).trim())).toList());
        } else if (ctx.EMPTY() != null) {
            values.add(new Primitive.Reference(new EmptyMogram()));
        }
        return values;
    }

    private List<Object> resolveValue(TaraGrammar.BodyValueContext ctx) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (ctx.stringValue() != null) {
            values.add(this.formatString(ctx.stringValue().getText()));
        } else if (ctx.expression() != null) {
            values.add(new Primitive.Expression(this.formatExpression(ctx.expression().getText()).trim()));
        }
        return values;
    }

    private String formatExpression(String value) {
        if (!value.trim().startsWith("--")) {
            return value.substring(1, value.length() - 1).replace("\\\"", "\"");
        }
        return this.format(value.trim().replaceAll("--(-*)\\n", "").replaceAll("--(-*)", ""));
    }

    private String formatString(String text) {
        String value = text.replace("\r", "");
        if (!value.trim().startsWith("\"\"\"")) {
            return value.substring(1, value.length() - 1).replace("\\\"", "\"");
        }
        return this.format(value.trim().replaceAll("\"\"(\"*)\\n", "").replaceAll("\"\"(\"*)", ""));
    }

    private String format(String text) {
        String pattern = this.pattern(text);
        StringBuilder result = new StringBuilder();
        for (String line : text.split("\\n")) {
            result.append(line.replaceFirst(pattern, "")).append("\n");
        }
        while (result.toString().endsWith("\n")) {
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    private String pattern(String text) {
        if (!text.contains("\n")) {
            return text;
        }
        String replace = text.substring(0, text.indexOf("\n"));
        return replace.replace(replace.trim(), "");
    }

    public Model getModel() {
        this.model.setUses(new ArrayList<String>(this.uses));
        return this.model;
    }

    public List<SyntaxException> getErrors() {
        return this.errors;
    }

    private void addError(String message, ParserRuleContext ctx) {
        this.errors.add(new SyntaxException(message, this.source.uri(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), ""));
    }

    private Element.TextRange textRange(ParserRuleContext ctx) {
        int startIndex = ctx.getStart().getStartIndex();
        int endIndex = ctx.getStop().getStopIndex() + 1;
        return new Element.TextRange(startIndex, endIndex, ctx.getStart().getLine(), ModelGenerator.firstLineLength(ctx), ctx.getStart().getCharPositionInLine(), ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine() + ctx.getStop().getText().length());
    }

    private Element.TextRange textRange(TaraGrammar.MogramContext ctx, ParserRuleContext nextMogram) {
        int startIndex = ctx.getStart().getStartIndex();
        int endIndex = nextMogram != null ? nextMogram.getStart().getStartIndex() : ctx.getParent().getStop().getStopIndex() + 1;
        int endLine = nextMogram != null ? nextMogram.getStart().getLine() : ctx.getParent().getStop().getLine();
        int endColumn = nextMogram != null ? nextMogram.getStart().getCharPositionInLine() : ctx.getParent().getStop().getCharPositionInLine();
        return new Element.TextRange(startIndex, endIndex, ctx.getStart().getLine(), ModelGenerator.firstLineLength(ctx), ctx.getStart().getCharPositionInLine(), endLine, endColumn);
    }

    private static int firstLineLength(ParserRuleContext ctx) {
        return ctx.getStop().getCharPositionInLine() + ctx.getStop().getText().length();
    }

    private static int firstLineLength(TaraGrammar.MogramContext ctx) {
        return ctx.signature().getStop().getCharPositionInLine() + ctx.signature().getStop().getText().length();
    }
}

