/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.parser.antlr;

import io.intino.tara.Source;
import io.intino.tara.language.grammar.SyntaxException;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.model.Element;
import io.intino.tara.model.constraints.Constraint;
import io.intino.tara.model.constraints.expressions.BooleanExpression;
import io.intino.tara.model.constraints.expressions.ComparisonExpression;
import io.intino.tara.model.constraints.expressions.ConstantExpression;
import io.intino.tara.model.constraints.expressions.Expression;
import io.intino.tara.model.constraints.expressions.FunctionCallExpression;
import io.intino.tara.model.constraints.expressions.InvalidExpression;
import io.intino.tara.model.constraints.expressions.LambdaExpression;
import io.intino.tara.model.constraints.expressions.LogicExpression;
import io.intino.tara.model.constraints.expressions.PropertyExpression;
import io.intino.tara.model.constraints.expressions.UnaryExpression;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class ConstraintsModelGenerator {
    private final Source source;
    private final TaraGrammar.RootContext root;
    private final List<SyntaxException> errors = new ArrayList<SyntaxException>();
    private Constraint current = null;

    public ConstraintsModelGenerator(Source source, TaraGrammar.RootContext root) {
        this.source = source;
        this.root = root;
    }

    public List<SyntaxException> errors() {
        return this.errors;
    }

    public List<Constraint> walk() {
        return this.root.mogramOrConstraint().stream().map(c -> c.constraintDef()).filter(Objects::nonNull).map(this::constraintOf).toList();
    }

    private Constraint constraintOf(TaraGrammar.ConstraintDefContext ctx) {
        String message = ctx.description() == null || ctx.description().STRING() == null ? "" : this.withoutQuotes(ctx.description().STRING().getText());
        this.current = new Constraint(this.source.uri(), ctx.IDENTIFIER().getText(), message, this.textRange(ctx));
        this.expression(ctx);
        return this.current;
    }

    private void expression(TaraGrammar.ConstraintDefContext ctx) {
        try {
            Expression expression = this.build(ctx.constraint());
            this.current.expression(expression);
        }
        catch (FunctionCallExpression.InvalidFunctionException | InvalidExpression e) {
            Element.TextRange textRange = this.textRange(ctx);
            this.errors.add(new SyntaxException(e.getMessage(), e, this.source.uri(), textRange.startLine(), textRange.startColumn()));
        }
        catch (SyntaxException e) {
            this.errors.add(e);
        }
    }

    private Expression build(TaraGrammar.ConstraintContext expression) throws SyntaxException, FunctionCallExpression.InvalidFunctionException, InvalidExpression {
        Element.TextRange textRange = this.textRange(expression);
        TaraGrammar.ConstraintContext constraintContext = expression;
        Objects.requireNonNull(constraintContext);
        TaraGrammar.ConstraintContext constraintContext2 = constraintContext;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TaraGrammar.BooleanExprContext.class, TaraGrammar.ComparisonExprContext.class, TaraGrammar.PrimaryExprContext.class, TaraGrammar.UnaryExprContext.class}, (Object)((Object)constraintContext2), n)) {
            case 0 -> {
                TaraGrammar.BooleanExprContext and = (TaraGrammar.BooleanExprContext)constraintContext2;
                yield this.buildLogical(and, textRange);
            }
            case 1 -> {
                TaraGrammar.ComparisonExprContext comparison = (TaraGrammar.ComparisonExprContext)constraintContext2;
                yield this.buildComparison(comparison, textRange);
            }
            case 2 -> {
                TaraGrammar.PrimaryExprContext cons = (TaraGrammar.PrimaryExprContext)constraintContext2;
                yield this.buildPrimary(cons.primary(), textRange);
            }
            case 3 -> {
                TaraGrammar.UnaryExprContext unary = (TaraGrammar.UnaryExprContext)constraintContext2;
                yield this.buildUnary(unary, textRange);
            }
            default -> null;
        };
    }

    private Expression buildUnary(TaraGrammar.UnaryExprContext unary, Element.TextRange textRange) throws SyntaxException, FunctionCallExpression.InvalidFunctionException, InvalidExpression {
        TaraGrammar.PrimaryExprContext pr;
        TaraGrammar.ConstraintContext expression = unary.constraint();
        if (!(expression instanceof TaraGrammar.BooleanExprContext || expression instanceof TaraGrammar.ComparisonExprContext || expression instanceof TaraGrammar.PrimaryExprContext && (pr = (TaraGrammar.PrimaryExprContext)expression).primary() instanceof TaraGrammar.GroupedExprContext)) {
            throw this.error("Only can be negated boolean expressions", textRange);
        }
        if (expression instanceof TaraGrammar.PrimaryExprContext && (pr = (TaraGrammar.PrimaryExprContext)expression).primary() instanceof TaraGrammar.GroupedExprContext) {
            expression = ((TaraGrammar.GroupedExprContext)pr.primary()).constraint();
        }
        return unary.unaryOp() != null ? UnaryExpression.createNOT((BooleanExpression)this.build(expression)) : this.build(expression);
    }

    private Expression buildProperty(TaraGrammar.PropertyNameContext prop, Element.TextRange textRange) {
        return new PropertyExpression(prop.IDENTIFIER().stream().map(ParseTree::getText).collect(Collectors.joining(".")));
    }

    private Expression buildPrimary(TaraGrammar.PrimaryContext primary, Element.TextRange textRange) throws SyntaxException, FunctionCallExpression.InvalidFunctionException, InvalidExpression {
        TaraGrammar.PrimaryContext primaryContext = primary;
        Objects.requireNonNull(primaryContext);
        TaraGrammar.PrimaryContext primaryContext2 = primaryContext;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TaraGrammar.VariableExprContext.class, TaraGrammar.GroupedExprContext.class, TaraGrammar.LiteralExprContext.class, TaraGrammar.FunctionExprContext.class, TaraGrammar.LambdaExprExprContext.class}, (Object)((Object)primaryContext2), n)) {
            case 0 -> {
                TaraGrammar.VariableExprContext variable = (TaraGrammar.VariableExprContext)primaryContext2;
                yield this.buildProperty(variable.propertyName(), textRange);
            }
            case 1 -> {
                TaraGrammar.GroupedExprContext expr = (TaraGrammar.GroupedExprContext)primaryContext2;
                yield this.build(expr.constraint());
            }
            case 2 -> {
                TaraGrammar.LiteralExprContext expr = (TaraGrammar.LiteralExprContext)primaryContext2;
                yield this.build(expr.literal());
            }
            case 3 -> {
                TaraGrammar.FunctionExprContext expr = (TaraGrammar.FunctionExprContext)primaryContext2;
                yield this.build(expr.functionCall());
            }
            case 4 -> {
                TaraGrammar.LambdaExprExprContext expr = (TaraGrammar.LambdaExprExprContext)primaryContext2;
                yield this.build(expr.lambdaExpr());
            }
            default -> null;
        };
    }

    private Expression build(TaraGrammar.FunctionCallContext ctx) throws SyntaxException, FunctionCallExpression.InvalidFunctionException, InvalidExpression {
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        if (ctx.argumentList() != null) {
            for (TaraGrammar.ConstraintContext e : ctx.argumentList().constraint()) {
                arguments.add(this.build(e));
            }
        }
        return new FunctionCallExpression(ctx.IDENTIFIER().getText(), arguments);
    }

    private Expression build(TaraGrammar.LambdaExprContext ctx) throws FunctionCallExpression.InvalidFunctionException, SyntaxException, InvalidExpression {
        return new LambdaExpression(ctx.IDENTIFIER().getText(), this.build(ctx.constraint()));
    }

    private Expression build(TaraGrammar.LiteralContext ctx) {
        if (ctx.EMPTY() != null) {
            return ConstantExpression.EMTPY;
        }
        if (ctx.BOOLEAN_VALUE() != null) {
            return new ConstantExpression(Boolean.parseBoolean(ctx.BOOLEAN_VALUE().getText()));
        }
        if (ctx.doubleValue() != null) {
            return new ConstantExpression(Double.parseDouble(ctx.doubleValue().getText()));
        }
        if (ctx.integerValue() != null) {
            return new ConstantExpression(Integer.parseInt(ctx.integerValue().getText()));
        }
        String text = ctx.STRING().getText();
        return new ConstantExpression(text.substring(1, text.length() - 1));
    }

    private Expression buildComparison(TaraGrammar.ComparisonExprContext comparison, Element.TextRange textRange) throws SyntaxException, FunctionCallExpression.InvalidFunctionException, InvalidExpression {
        boolean negated;
        Expression left = this.build(comparison.constraint(0));
        Expression right = this.build(comparison.constraint(1));
        TaraGrammar.BinaryCompContext operator = comparison.binaryComp();
        boolean bl = negated = operator.NOT() != null;
        if (operator.IN() != null) {
            return ComparisonExpression.createInFilter(left, right, negated);
        }
        if (operator.COMPARER_EQUALS() != null) {
            return ComparisonExpression.createEqual(left, right, negated);
        }
        if (operator.NOT_EQUALS() != null) {
            return UnaryExpression.createNOT(ComparisonExpression.createEqual(left, right, negated));
        }
        if (operator.LESS() != null) {
            return ComparisonExpression.createLessThan(left, right);
        }
        if (operator.LESS_EQUALS() != null) {
            return ComparisonExpression.createLessThanEqual(left, right);
        }
        if (operator.GREATER() != null) {
            return ComparisonExpression.createGreaterThan(left, right);
        }
        if (operator.GREATER_EQUALS() != null) {
            return ComparisonExpression.createGreaterThanEqual(left, right);
        }
        if (operator.IS() != null) {
            if (!(right instanceof ConstantExpression) && !(right instanceof PropertyExpression)) {
                throw this.error("After 'is' must be a type of mogram or empty", textRange);
            }
            return ComparisonExpression.createIs(left, right, negated);
        }
        if (operator.MATCHES() != null) {
            return ComparisonExpression.createMatch(left, (ConstantExpression)right, "\"", negated);
        }
        if (operator.LIKE() != null) {
            return ComparisonExpression.createLike(left, ((ConstantExpression)right).getValue().toString(), "\"", negated);
        }
        if (operator.STARTS_WITH() != null) {
            return ComparisonExpression.createStartsWith(left, ((ConstantExpression)right).getValue().toString(), "\"", negated);
        }
        throw this.error("Error building comparison expression. Operator not found: " + operator.getText(), textRange);
    }

    private BooleanExpression buildLogical(TaraGrammar.BooleanExprContext expr, Element.TextRange textRange) throws SyntaxException, FunctionCallExpression.InvalidFunctionException, InvalidExpression {
        Expression left = this.build(expr.constraint(0));
        Expression right = this.build(expr.constraint(1));
        if (!(left instanceof BooleanExpression) || !(right instanceof BooleanExpression)) {
            throw this.expectedOperandType(textRange);
        }
        if (expr.OR() != null) {
            return LogicExpression.createOR((BooleanExpression)left, (BooleanExpression)right);
        }
        return LogicExpression.createAND((BooleanExpression)left, (BooleanExpression)right);
    }

    private SyntaxException error(String message, Element.TextRange textRange) {
        return new SyntaxException(message, this.source.uri(), textRange.startLine(), textRange.startColumn());
    }

    private SyntaxException expectedOperandType(Element.TextRange textRange) {
        return new SyntaxException("Logical expressions require boolean operands", this.source.uri(), textRange.startLine(), textRange.startColumn());
    }

    private Element.TextRange textRange(ParserRuleContext ctx) {
        int startIndex = ctx.getStart().getStartIndex();
        int endIndex = ctx.getParent().getStop().getStopIndex() + 1;
        int endLine = ctx.getParent().getStop().getLine();
        int endColumn = ctx.getParent().getStop().getCharPositionInLine();
        return new Element.TextRange(startIndex, endIndex, ctx.getStart().getLine(), ConstraintsModelGenerator.firstLineLength(ctx), ctx.getStart().getCharPositionInLine(), endLine, endColumn);
    }

    private static int firstLineLength(ParserRuleContext ctx) {
        return ctx.getStop().getCharPositionInLine() + ctx.getStop().getText().length();
    }

    private String withoutQuotes(String text) {
        return text.substring(1, text.length() - 1);
    }
}

