/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.model;

import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class PropertyImpl
implements Property,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getGlobal();
    private final String name;
    private final List<Object> defaultValues = new ArrayList<Object>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final Element.TextRange range;
    private final List<Rule<?>> rules = new ArrayList();
    private Mogram container;
    private Primitive type;
    private String doc;
    private String metric;
    private Property overridden;
    private Property overrides;
    private String uid;

    public PropertyImpl(Mogram container, Primitive type, String name, int line, Element.TextRange range) {
        this.container = container;
        this.name = name;
        this.type = type;
        this.range = range;
    }

    @Override
    public Primitive type() {
        return this.type;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public void type(Primitive type) {
        this.type = type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Mogram container() {
        return this.container;
    }

    @Override
    public void container(Mogram container) {
        this.container = container;
    }

    @Override
    public List<Annotation> annotations() {
        return this.annotations;
    }

    @Override
    public void addAnnotations(Annotation ... flags) {
        Collections.addAll(this.annotations, flags);
    }

    @Override
    public List<Rule<?>> rules() {
        return this.rules;
    }

    @Override
    public void add(Rule<?> rule) {
        this.rules.add(rule);
    }

    @Override
    public void values(List<Object> values) {
        this.defaultValues.clear();
        this.defaultValues.addAll(values);
    }

    @Override
    public List<Object> values() {
        return Collections.unmodifiableList(this.makeUp(this.model().resourcesRoot(), this.type(), this.defaultValues));
    }

    private MogramRoot model() {
        ElementContainer container = this.container();
        while (!(container instanceof MogramRoot)) {
            container = container.container();
        }
        return (MogramRoot)container;
    }

    @Override
    public String metric() {
        return this.metric;
    }

    @Override
    public void metric(String metric) {
        this.metric = metric;
    }

    @Override
    public String getUID() {
        if (this.uid == null) {
            this.uid = "" + Property.NativeCounter.next(this.container(), this.name());
        }
        return this.uid;
    }

    @Override
    public URI source() {
        return this.container.source();
    }

    @Override
    public int line() {
        return this.range.startLine();
    }

    @Override
    public Element.TextRange textRange() {
        return this.range;
    }

    @Override
    public String doc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public Property clone() throws CloneNotSupportedException {
        super.clone();
        PropertyImpl clone = new PropertyImpl(this.container, this.type, this.name, this.line(), this.range);
        clone.source(this.source());
        clone.metric(this.metric);
        this.rules.forEach(clone::add);
        this.annotations.forEach(xva$0 -> clone.addAnnotations((Annotation)xva$0));
        clone.values(this.defaultValues);
        return clone;
    }

    @Override
    public Property cloneIt(Mogram container) {
        try {
            Property clone = this.clone();
            clone.container(container);
            return clone;
        }
        catch (CloneNotSupportedException ignored) {
            LOG.severe("Error cloning variable: " + this.name());
            return null;
        }
    }

    public String toString() {
        return String.valueOf(this.type) + ":" + this.name;
    }

    @Override
    public Property overriden() {
        return this.overridden;
    }

    @Override
    public Property overrides() {
        return this.overrides;
    }

    @Override
    public void overriden(Property childrenProp) {
        this.overridden = childrenProp;
    }

    @Override
    public void overrides(Property superProp) {
        this.overrides = superProp;
    }
}

