/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.model;

import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.Rule;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PropertyDescriptionImpl
implements PropertyDescription,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Object> values = new ArrayList<Object>();
    private final List<Object> originalValues = new ArrayList<Object>();
    private Property definition;
    private final int position;
    private String name;
    private String scope;
    private final Element.TextRange range;
    private String metric;
    private Primitive inferredType;
    private boolean multiple;
    private final List<Rule<?>> rules = new ArrayList();
    private Mogram container;
    private String uid;
    private String facet;

    public PropertyDescriptionImpl(String name, int position, String metric, List<Object> values, Element.TextRange range) {
        this.name = name;
        this.position = position;
        this.metric = metric == null ? "" : metric;
        this.range = range;
        this.addOriginalValues(values);
        this.addValues(values);
    }

    public PropertyDescriptionImpl(int position, String metric, List<Object> values, Element.TextRange range) {
        this("", position, metric, values, range);
    }

    @Override
    public Mogram container() {
        return this.container;
    }

    public void owner(Mogram owner) {
        this.container = owner;
    }

    @Override
    public Primitive type() {
        return this.inferredType;
    }

    @Override
    public void type(Primitive type) {
        this.inferredType = type;
    }

    @Override
    public String facet() {
        return this.facet;
    }

    @Override
    public void facet(String facet) {
        this.facet = facet;
    }

    @Override
    public Property definition() {
        return this.definition;
    }

    @Override
    public void definition(Property property) {
        this.definition = property;
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public void multiple(boolean multiple) {
        this.multiple = multiple;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String name) {
        this.name = name;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public List<Object> values() {
        return Collections.unmodifiableList(this.makeUp(this.model().resourcesRoot(), this.inferredType, this.values));
    }

    @Override
    public List<Object> originalValues() {
        return this.originalValues;
    }

    private MogramRoot model() {
        ElementContainer container = this.container;
        while (!(container instanceof MogramRoot)) {
            container = container.container();
        }
        return (MogramRoot)container;
    }

    @Override
    public void values(List<Object> objects) {
        this.addValues(objects);
    }

    @Override
    public List<Rule<?>> rules() {
        return this.rules;
    }

    @Override
    public void add(Rule<?> rule) {
        this.rules.add(rule);
    }

    @Override
    public void scope(String scope) {
        this.scope = scope;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public URI source() {
        return this.container().source();
    }

    @Override
    public int line() {
        return this.textRange().startLine();
    }

    @Override
    public Element.TextRange textRange() {
        return this.range;
    }

    @Override
    public String doc() {
        return "";
    }

    @Override
    public String metric() {
        return this.metric;
    }

    @Override
    public void metric(String metric) {
        this.metric = metric == null ? "" : metric;
    }

    public String toString() {
        return this.name + ":" + this.position + ":" + String.valueOf(this.values);
    }

    @Override
    public void substituteValues(List<?> newValues) {
        this.addValues(newValues);
    }

    @Override
    public String getUID() {
        if (this.uid == null) {
            this.uid = "" + Property.NativeCounter.next(this.container(), this.name());
        }
        return this.uid;
    }

    private void addValues(List<Object> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    private void addOriginalValues(List<Object> values) {
        this.originalValues.clear();
        this.originalValues.addAll(values);
    }
}

