/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.model;

import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.model.NamedReference;
import io.intino.tara.model.Property;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.Rule;
import io.intino.tara.processors.model.PropertyDescriptionImpl;
import io.intino.tara.processors.utils.Format;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MogramImpl
implements Mogram,
Serializable {
    private static final long serialVersionUID = 1L;
    private URI source;
    private final Element.TextRange range;
    private final String text;
    private int line;
    private ElementContainer container;
    private String mainType;
    private String doc;
    private boolean sub;
    private String name;
    private NamedReference<Mogram> parent;
    private NamedReference<Mogram> overrides;
    private NamedReference<Mogram> overriden;
    private boolean anonymous = true;
    private String hashCode;
    private String language;
    private final Map<Element, List<Rule<?>>> elements = new LinkedHashMap();
    private final Set<Annotation> annotations = new HashSet<Annotation>();
    private final List<PropertyDescription> propertyDescriptions = new ArrayList<PropertyDescription>();
    private final List<Facet> facetsApplied = new ArrayList<Facet>();
    private final List<NamedReference<Mogram>> applicableFacets = new ArrayList<NamedReference<Mogram>>();
    private final List<Mogram> children = new ArrayList<Mogram>();
    private final Set<Mogram> metaMograms = new HashSet<Mogram>();
    private List<Mogram.FacetConstraint> facetConstraints;
    private Level level;
    private NamedReference<Mogram> facetTarget;

    public MogramImpl(String text, URI source, int line, Element.TextRange range) {
        this.text = text;
        this.source = source;
        this.line = line;
        this.range = range;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String name) {
        this.name = name;
    }

    public void anonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public Level level() {
        return this.level;
    }

    @Override
    public void level(Level level) {
        this.level = level;
    }

    @Override
    public boolean isSub() {
        return this.sub;
    }

    @Override
    public List<NamedReference<Mogram>> applicableFacets() {
        return this.applicableFacets;
    }

    @Override
    public void addApplicableFacet(Mogram mogram) {
        this.applicableFacets.add(new NamedReference<Mogram>(mogram, mogram.qualifiedName()));
    }

    public void setSub(boolean sub) {
        this.sub = sub;
    }

    @Override
    public URI source() {
        return this.source;
    }

    @Override
    public void source(URI source) {
        this.source = source;
    }

    @Override
    public String languageName() {
        return this.language;
    }

    @Override
    public void languageName(String language) {
        this.language = language;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public void line(int line) {
        this.line = line;
    }

    @Override
    public Element.TextRange textRange() {
        return this.range;
    }

    @Override
    public String doc() {
        return this.doc;
    }

    @Override
    public void doc(String doc) {
        this.doc = this.doc == null ? doc : this.doc + "\\n" + doc.trim();
    }

    @Override
    public List<Mogram> subs() {
        ArrayList mograms = new ArrayList();
        this.children().stream().filter(Mogram::isSub).forEach(c -> {
            mograms.add(c);
            mograms.addAll(c.subs());
        });
        return Collections.unmodifiableList(mograms);
    }

    @Override
    public List<Mogram> facets() {
        return this.elements.keySet().stream().filter(e -> {
            Mogram m;
            return e instanceof Mogram && (m = (Mogram)e).facetPrescription() != null;
        }).map(e -> (Mogram)e).toList();
    }

    @Override
    public ElementContainer container() {
        return this.container;
    }

    @Override
    public void container(ElementContainer container) {
        this.container = container;
    }

    @Override
    public NamedReference<Mogram> facetPrescription() {
        return this.facetTarget;
    }

    @Override
    public void facetPrescription(String target) {
        this.facetTarget = new NamedReference(target);
    }

    @Override
    public void facetPrescription(Mogram target) {
        this.facetTarget = new NamedReference<Mogram>(target, target.name());
    }

    @Override
    public List<Mogram.FacetConstraint> facetConstraints() {
        return this.facetConstraints == null ? Collections.emptyList() : this.facetConstraints;
    }

    public void facetConstraints(List<Mogram.FacetConstraint> constraints) {
        this.facetConstraints = constraints;
    }

    @Override
    public boolean is(Annotation annotation) {
        return this.annotations.contains(annotation);
    }

    @Override
    public List<Annotation> annotations() {
        return List.copyOf(this.annotations);
    }

    @Override
    public void addAnnotations(Annotation ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    @Override
    public NamedReference<Mogram> parent() {
        return this.parent;
    }

    public void parent(Mogram parent) {
        if (this.parent == null) {
            this.parent = new NamedReference<Mogram>(parent, parent.qualifiedName());
        } else {
            this.parent.referent(parent);
        }
    }

    public void parent(String parent) {
        if (this.parent == null && parent != null) {
            this.parent = new NamedReference(parent);
        }
    }

    @Override
    public Mogram overrides() {
        return this.overrides == null ? null : this.overrides.get();
    }

    @Override
    public void overrides(Mogram mogram) {
        this.overrides = new NamedReference<Mogram>(mogram, mogram.qualifiedName());
    }

    @Override
    public void overridenBy(Mogram mogram) {
        this.overriden = new NamedReference<Mogram>(mogram, mogram.qualifiedName());
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public List<Mogram> metaMograms() {
        return List.copyOf(this.metaMograms);
    }

    @Override
    public void addMetaMogram(Mogram mogram) {
        this.metaMograms.add(mogram);
    }

    @Override
    public String qualifiedName() {
        String string;
        ElementContainer elementContainer = this.container;
        if (elementContainer instanceof Mogram) {
            Mogram m = (Mogram)elementContainer;
            string = m.qualifiedName();
        } else {
            string = "";
        }
        String containerQN = string;
        String name = this.level == null || this.level == Level.M1 || this.isAnonymous() ? this.name() : Format.firstUpperCase(this.name());
        return (String)(containerQN.isEmpty() ? "" : containerQN + ".") + (String)(name == null ? "[anonymous@" + this.shortType() + "]" : name);
    }

    @Override
    public void type(String type) {
        this.mainType = type;
    }

    @Override
    public String shortType() {
        return this.mainType.contains(".") ? this.mainType.substring(this.mainType.lastIndexOf(".") + 1) : this.mainType;
    }

    @Override
    public List<String> types() {
        ArrayList<String> types = new ArrayList<String>(this.secondaryTypes());
        types.addFirst(this.mainType);
        return types;
    }

    public List<String> secondaryTypes() {
        Set types = this.appliedFacets().stream().map(facet -> facet.fullType() != null ? facet.fullType() : facet.type()).collect(Collectors.toSet());
        if (this.parent != null && this.parent.resolved()) {
            types.addAll(this.parent.get().types());
        }
        return List.copyOf(types);
    }

    @Override
    public List<PropertyDescription> parameters() {
        return Collections.unmodifiableList(this.propertyDescriptions);
    }

    @Override
    public void addParameter(String name, String facet, int position, String extension, Element.TextRange range, List<Object> values) {
        PropertyDescriptionImpl property = new PropertyDescriptionImpl(name, position, extension, values, range);
        property.facet(facet);
        property.owner(this);
        this.propertyDescriptions.add(property);
    }

    public void add(PropertyDescription parameter) {
        this.propertyDescriptions.add(parameter);
    }

    @Override
    public List<Mogram> siblings() {
        ArrayList<Mogram> siblings = new ArrayList<Mogram>(this.container().mograms());
        siblings.remove(this);
        return Collections.unmodifiableList(siblings);
    }

    @Override
    public List<Element> elements() {
        return List.copyOf(this.elements.keySet());
    }

    @Override
    public List<Mogram> components() {
        return this.elements.keySet().stream().filter(e -> {
            Mogram m;
            return e instanceof Mogram && (m = (Mogram)e).facetPrescription() == null;
        }).map(e -> (Mogram)e).toList();
    }

    @Override
    public List<Mogram> mograms() {
        return this.elements.keySet().stream().filter(e -> e instanceof Mogram).map(e -> (Mogram)e).toList();
    }

    @Override
    public List<Rule<?>> rulesOf(Element component) {
        return this.elements.get(component);
    }

    public boolean contains(Mogram mogramContainer) {
        return mogramContainer != null && this.elements.containsKey(mogramContainer);
    }

    @Override
    public List<Property> properties() {
        return this.elements.keySet().stream().filter(e -> e instanceof Property).map(e -> (Property)e).toList();
    }

    @Override
    public void add(Element element, List<Rule<?>> rules) {
        this.elements.put(element, rules == null ? new ArrayList() : new ArrayList(rules));
    }

    public void add(Property ... properties) {
        Arrays.stream(properties).forEach(property -> this.elements.put((Element)property, new ArrayList()));
    }

    public void remove(Mogram mogram) {
        if (mogram != null) {
            this.elements.remove(mogram);
        }
    }

    @Override
    public List<MogramReference> referenceComponents() {
        return this.elements.keySet().stream().filter(e -> e instanceof MogramReference && !(e instanceof Property)).map(e -> (MogramReference)e).toList();
    }

    @Override
    public List<Mogram> children() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Mogram mogram) {
        this.children.add(mogram);
    }

    @Override
    public List<Facet> appliedFacets() {
        return Collections.unmodifiableList(this.facetsApplied);
    }

    @Override
    public void applyFacet(Facet facet) {
        Collections.addAll(this.facetsApplied, facet);
    }

    @Override
    public String toString() {
        return this.mainType + " " + this.qualifiedName();
    }

    public String text() {
        return this.text;
    }

    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    public String getHashCode() {
        return this.hashCode;
    }
}

