/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.model;

import io.intino.tara.model.Annotation;
import io.intino.tara.model.Element;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.model.NamedReference;
import io.intino.tara.processors.model.MogramImpl;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HasMogram
implements MogramReference,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Element.TextRange textRange;
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final URI source;
    private final NamedReference<Mogram> target;
    private int line;
    private Mogram container;
    private String doc;
    private boolean has;

    public HasMogram(String reference, URI source, int line, Element.TextRange textRange) {
        this.target = new NamedReference(reference);
        this.source = source;
        this.line = line;
        this.textRange = textRange;
    }

    public HasMogram(MogramImpl target, URI source, Element.TextRange textRange) {
        this.source = source;
        this.textRange = textRange;
        this.target = new NamedReference<MogramImpl>(target, target.name());
    }

    @Override
    public NamedReference<Mogram> target() {
        return this.target;
    }

    public void target(Mogram target) {
        this.target.referent(target);
    }

    public boolean isHas() {
        return this.has;
    }

    public void setHas(boolean has) {
        this.has = has;
    }

    public Mogram container() {
        return this.container;
    }

    public HasMogram container(Mogram container) {
        this.container = container;
        return this;
    }

    public List<Annotation> annotations() {
        ArrayList<Annotation> all = new ArrayList<Annotation>();
        this.annotations.stream().filter(a -> !all.contains(a)).forEach(all::add);
        if (this.isHas()) {
            all.addAll(this.target.get().annotations());
        }
        return Collections.unmodifiableList(all);
    }

    public void addAnnotations(Annotation ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    public String qualifiedName() {
        return this.container.qualifiedName() + "." + this.target.get().name();
    }

    @Override
    public String doc() {
        return this.doc;
    }

    @Override
    public void doc(String doc) {
        this.doc = doc;
    }

    @Override
    public URI source() {
        return this.source;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public Element.TextRange textRange() {
        return this.textRange;
    }

    public String toString() {
        return this.target.resolved() ? this.qualifiedName() : this.target.reference();
    }
}

