/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.dependencyresolution;

import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramRoot;
import io.intino.tara.model.NamedReference;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.constraints.Constraint;
import io.intino.tara.processors.model.HasMogram;
import io.intino.tara.processors.model.MogramImpl;
import io.intino.tara.processors.model.ReferenceProperty;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferenceManager {
    private final MogramRoot model;

    ReferenceManager(MogramRoot model) {
        this.model = model;
    }

    public Mogram resolve(HasMogram reference) {
        return this.resolve(reference.target(), reference.container());
    }

    Mogram resolve(ReferenceProperty property, Mogram container) {
        Mogram result = this.resolve(property.target(), container);
        return result instanceof HasMogram ? ((HasMogram)((Object)result)).target().get() : (MogramImpl)result;
    }

    Mogram resolvePropReference(Primitive.Reference value, Mogram mogram) {
        String[] path = value.get().reference().split("\\.");
        List<Mogram> roots = this.findRoots(mogram, path).stream().filter(n -> !n.equals(mogram)).collect(Collectors.toList());
        return this.selectFromOptions(mogram, path, roots);
    }

    Mogram resolve(NamedReference<Mogram> reference, Mogram context) {
        String[] path = reference.reference().split("\\.");
        Collection<Mogram> roots = this.findRoots(context, path);
        return this.selectFromOptions(context, path, roots);
    }

    Constraint resolve(NamedReference<Constraint> reference) {
        return this.model.constraints().stream().filter(c -> c.name().equals(reference.reference())).findFirst().orElse(null);
    }

    Mogram resolveParent(String reference, ElementContainer mogram) {
        return this.resolve(reference.split("\\."), this.searchPossibleRoots(mogram, reference.split("\\.")[0], true));
    }

    private Mogram selectFromOptions(Mogram mogram, String[] path, Collection<Mogram> roots) {
        return this.resolve(path, this.sortRootsByFile(roots, mogram.source()));
    }

    private Collection<Mogram> sortRootsByFile(Collection<Mogram> roots, URI uri) {
        List<Mogram> mograms = roots.stream().filter(node -> node.source().equals(uri)).collect(Collectors.toList());
        roots.stream().filter(root -> !mograms.contains(root)).forEach(mograms::add);
        return mograms;
    }

    private Collection<Mogram> findRoots(Mogram mogram, String[] path) {
        Collection<Mogram> roots = this.searchPossibleRoots(mogram, path[0], false);
        if (!roots.isEmpty()) {
            return roots;
        }
        for (Mogram root : this.model.mograms()) {
            if (!ReferenceManager.getNameWithoutExtension(new File(root.source().getPath()).getName()).equals(path[0]) || path.length == 1) continue;
            roots = this.searchPossibleRoots(root, path[1], false);
            break;
        }
        return roots;
    }

    private Mogram resolve(String[] path, Collection<Mogram> roots) {
        if (roots.isEmpty()) {
            return null;
        }
        if (roots.size() == 1 && path.length == 1) {
            return roots.iterator().next();
        }
        for (Mogram root : roots) {
            Mogram candidate = ReferenceManager.resolvePathInMogram(path, root);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public static Mogram resolvePathInMogram(String[] path, Mogram mogram) {
        ElementContainer reference = null;
        for (String name : path) {
            if (reference == null) {
                reference = ReferenceManager.areNamesake(mogram, name) ? mogram : null;
                continue;
            }
            List<Mogram> containedMograms = reference.mograms().stream().filter(m -> m.name().equals(name)).toList();
            if (containedMograms.isEmpty() && reference.parent() != null) {
                reference = reference.parent().get().mograms().stream().filter(m -> m.name().equals(name)).findFirst().orElse(null);
            } else {
                ElementContainer elementContainer = reference = containedMograms.isEmpty() ? null : containedMograms.get(0);
            }
            if (reference != null) continue;
            return null;
        }
        return reference;
    }

    private Collection<Mogram> searchPossibleRoots(ElementContainer mogram, String name, boolean parent) {
        LinkedHashSet<Mogram> set = new LinkedHashSet<Mogram>();
        if (mogram instanceof MogramImpl && ReferenceManager.areNamesake((Mogram)mogram, name)) {
            set.add((Mogram)mogram);
        }
        this.addInContext(name, set, mogram, parent);
        this.addMogramSiblings(name, mogram, set);
        this.addRoots(name, set);
        return set;
    }

    private void addRoots(String name, Set<Mogram> set) {
        set.addAll(this.model.mograms().stream().filter(node -> ReferenceManager.areNamesake(node, name)).toList());
    }

    private void addMogramSiblings(String identifier, ElementContainer container, Set<Mogram> set) {
        if (container == null) {
            return;
        }
        set.addAll(container.mograms().stream().filter(node -> ReferenceManager.areNamesake(node, identifier)).toList());
    }

    private void addInContext(String name, Set<Mogram> set, ElementContainer mogram, boolean parent) {
        this.checkSiblings(name, set, mogram);
        for (ElementContainer container = mogram.container(); container != null; container = container.container()) {
            Mogram m;
            NamedReference<Mogram> parentMogram;
            if (container instanceof MogramImpl && ReferenceManager.areNamesake((Mogram)container, name)) {
                set.add((Mogram)container);
            }
            this.checkSiblings(name, set, container);
            if (!parent || !(mogram instanceof Mogram) || (parentMogram = (m = (Mogram)mogram).parent()) == null || !parentMogram.resolved()) continue;
            this.collectParentElements(name, set, container, parentMogram.get());
        }
    }

    private void checkSiblings(String name, Set<Mogram> set, ElementContainer container) {
        container.siblings().stream().filter(sibling -> sibling instanceof MogramImpl && ReferenceManager.areNamesake(sibling, name)).forEach(set::add);
    }

    private void collectParentElements(String identifier, Set<Mogram> set, ElementContainer container, Mogram parent) {
        set.addAll(parent.mograms().stream().filter(sibling -> ReferenceManager.areNamesake(sibling, identifier) && !sibling.equals(container)).toList());
    }

    public static String getNameWithoutExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    private static boolean areNamesake(Mogram mogram, String name) {
        return name.equals(mogram.name());
    }
}

