/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.dependencyresolution;

import io.intino.tara.model.Annotation;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import io.intino.tara.model.Valued;
import io.intino.tara.model.rules.Size;
import io.intino.tara.model.rules.property.FunctionRule;
import io.intino.tara.model.rules.property.NativeCustomWordRule;
import io.intino.tara.model.rules.property.NativeReferenceRule;
import io.intino.tara.model.rules.property.NativeWordRule;
import io.intino.tara.model.rules.property.ReferenceRule;
import io.intino.tara.model.rules.property.TypeRule;
import io.intino.tara.model.rules.property.WordRule;
import io.intino.tara.processors.dependencyresolution.DependencyException;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.model.MogramImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class NativeResolver {
    private static final Logger LOG = Logger.getGlobal();
    private final Model model;
    private final File functionsDirectory;

    public NativeResolver(Model model, File functionsDirectory) {
        this.model = model;
        this.functionsDirectory = functionsDirectory;
    }

    public void resolve() throws DependencyException {
        for (Mogram mogram : this.model.mograms()) {
            this.resolve(mogram);
        }
    }

    private void resolve(Mogram mogram) throws DependencyException {
        if (!(mogram instanceof MogramImpl)) {
            return;
        }
        this.resolveNative(mogram.properties());
        this.resolveNative(mogram.parameters());
        for (Mogram include : mogram.mograms()) {
            this.resolve(include);
        }
    }

    private void resolveNative(List<? extends Valued> valuedList) throws DependencyException {
        for (Valued valued : valuedList) {
            for (Rule<?> rule : List.copyOf(valued.rules())) {
                Property p;
                if (rule instanceof Size || !(rule instanceof FunctionRule) && (valued.values().isEmpty() || !(valued.values().get(0) instanceof Primitive.Expression) && !(valued.values().get(0) instanceof Primitive.MethodReference)) && (!(valued instanceof Property) || !(p = (Property)valued).annotations().contains(Annotation.Reactive))) continue;
                this.fillRule(valued, rule);
            }
        }
    }

    private void fillRule(Valued valued, Rule<?> rule) throws DependencyException {
        if (rule == null) {
            valued.add(new FunctionRule("", "", new ArrayList<String>()));
        } else if (rule instanceof ReferenceRule) {
            valued.rules().remove(rule);
            valued.add(new NativeReferenceRule(((ReferenceRule)rule).allowedReferences()));
        } else if (rule instanceof WordRule) {
            valued.rules().remove(rule);
            if (((WordRule)rule).externalClass() == null) {
                valued.add(new NativeWordRule(((WordRule)rule).words()));
            } else {
                valued.add(new NativeCustomWordRule(((WordRule)rule).words(), ((WordRule)rule).externalClass()));
            }
        } else if (rule instanceof TypeRule) {
            valued.rules().remove(rule);
        }
        if (rule instanceof FunctionRule) {
            this.fillInfo(valued, (FunctionRule)rule);
        }
    }

    private void fillInfo(Valued valued, FunctionRule rule) throws DependencyException {
        if (valued instanceof Property && valued.type().equals(Primitive.FUNCTION)) {
            this.fillPropertyInfo((Property)valued, rule);
        }
    }

    private void fillPropertyInfo(Property prop, FunctionRule rule) throws DependencyException {
        if (this.functionsDirectory == null || !this.functionsDirectory.exists()) {
            throw new DependencyException("reject.nonexistent.functions.directory", prop, new String[0]);
        }
        File[] files = this.functionsDirectory.listFiles((dir, filename) -> filename.endsWith(".java") && filename.substring(0, filename.lastIndexOf(".")).equalsIgnoreCase(rule.interfaceClass()));
        if ((files != null ? files.length : 0) == 0) {
            throw new DependencyException("reject.nonexistent.property.rule", prop, new String[0]);
        }
        String text = this.readFile(files[0]);
        String signature = this.getSignature(text);
        if (signature.isEmpty()) {
            throw new DependencyException("reject.native.signature.not.found", prop, new String[0]);
        }
        rule.signature(signature);
        rule.imports(this.getInterfaceImports(Arrays.asList(text.split("\n"))));
    }

    private String getSignature(String text) {
        text = ((String)text).substring(((String)text).indexOf("{") + 1, ((String)text).indexOf(";", ((String)text).indexOf("{") + 1)).trim();
        if (!((String)(text = ((String)text).replaceAll("//.*\n", ""))).startsWith("public")) {
            text = "public " + (String)text;
        }
        return text;
    }

    private List<String> getInterfaceImports(List<String> text) {
        return text.stream().map(String::trim).filter(trim -> trim.startsWith("import ")).distinct().collect(Collectors.toList());
    }

    private String readFile(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            LOG.severe("File cannot be read: " + file.getAbsolutePath());
            return "";
        }
    }
}

