/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.processors.dependencyresolution;

import io.intino.tara.model.Annotation;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Property;
import io.intino.tara.model.Rule;
import io.intino.tara.model.rules.Size;
import io.intino.tara.model.rules.composition.ConstraintRule;
import io.intino.tara.processors.Resolver;
import io.intino.tara.processors.dependencyresolution.DependencyException;
import io.intino.tara.processors.model.HasMogram;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.model.MogramImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class InheritanceResolver {
    private final Model model;

    public InheritanceResolver(Model model) {
        this.model = model;
    }

    public void resolve() throws DependencyException {
        List<Mogram> mograms = this.sort(new ArrayList<Mogram>(this.collectMograms(this.model, node -> !node.children().isEmpty())));
        for (Mogram mogram : mograms) {
            this.resolve(mogram);
        }
    }

    private void resolve(Mogram mogram) throws DependencyException {
        List<Mogram> children = this.getChildrenSorted(mogram);
        if (!(mogram.is(Annotation.Generalization) || mogram.subs().isEmpty() || mogram.annotations().contains(Annotation.Generalization))) {
            mogram.addAnnotations(Annotation.Generalization);
        }
        for (Mogram child : children) {
            this.resolve(mogram, child);
        }
    }

    private void resolve(Mogram mogram, Mogram child) throws DependencyException {
        this.resolveComponents(mogram, child);
        this.resolveProperties(mogram, child);
        this.resolveAnnotations(mogram, child);
        this.resolveAllowedFacets(mogram, child);
        this.resolveAppliedFacets(mogram, child);
        this.resolveMogramRules(mogram, child);
        this.resolve(child);
    }

    private void resolveMogramRules(Mogram parent, Mogram child) {
        List<Rule<?>> parentRules = parent.container().rulesOf(parent);
        List<Rule<?>> childRules = child.container().rulesOf(child);
        Size size = child.container().sizeOf(child);
        for (Rule<?> rule : parentRules) {
            if (!(rule instanceof Size)) {
                if (this.alreadyAdded(childRules, rule)) continue;
                childRules.add(rule);
                continue;
            }
            if (!this.isMoreRestrictiveThan((Size)rule, size)) continue;
            childRules.remove(size);
            childRules.add(rule);
        }
    }

    private boolean alreadyAdded(List<Rule<?>> childRules, Rule<?> rule) {
        if (rule instanceof ConstraintRule) {
            ConstraintRule nr = (ConstraintRule)rule;
            return childRules.stream().filter(r -> r instanceof ConstraintRule).anyMatch(r -> ((ConstraintRule)r).reference().reference().equals(nr.reference().reference()));
        }
        return false;
    }

    private boolean isMoreRestrictiveThan(Size parent, Size child) {
        return parent.min() > child.min() || parent.max() < child.max();
    }

    private void resolveAllowedFacets(Mogram parent, Mogram child) {
    }

    private void resolveAppliedFacets(Mogram parent, Mogram child) {
        parent.appliedFacets().stream().filter(facet -> !this.isOverridden(child, (Facet)facet)).forEach(child::applyFacet);
    }

    private boolean isOverridden(Mogram child, Facet facet) {
        return child.appliedFacets().stream().anyMatch(childFacet -> childFacet.type().equals(facet.type()));
    }

    private Collection<Mogram> collectMograms(Model model, Predicate<Mogram> condition) {
        HashSet<Mogram> collection = new HashSet<Mogram>();
        for (Mogram mogram : model.components()) {
            if (condition.test(mogram)) {
                collection.add(mogram);
            }
            this.collect(mogram, collection, condition);
        }
        return collection;
    }

    private void collect(Mogram mogram, Set<Mogram> collection, Predicate<Mogram> condition) {
        if (!(mogram instanceof MogramImpl)) {
            return;
        }
        if (condition.test(mogram)) {
            collection.add(mogram);
        }
        for (Mogram component : mogram.components()) {
            this.collect(component, collection, condition);
        }
    }

    private void resolveComponents(Mogram parent, Mogram child) {
        parent.components().stream().filter(component -> this.isOverridden((ElementContainer)child, (Mogram)component)).forEach(c -> {
            child.overrides((Mogram)c);
            c.overridenBy(child);
        });
    }

    private void resolveAnnotations(Mogram parent, Mogram child) {
        parent.annotations().stream().filter(a -> !a.equals(Annotation.Generalization) && !child.annotations().contains(a)).forEach(xva$0 -> child.addAnnotations((Annotation)xva$0));
    }

    private void resolveProperties(Mogram parent, Mogram child) {
        for (Property prop : parent.properties()) {
            Property childrenProp;
            if (!this.isOverridden(child, prop) || (childrenProp = this.findProperty(child, prop.name())) == null) continue;
            prop.overriden(childrenProp);
            childrenProp.overrides(prop);
        }
    }

    private Property findProperty(Mogram child, String name) {
        for (Property variable : child.properties()) {
            if (!variable.name().equals(name)) continue;
            return variable;
        }
        return null;
    }

    private boolean isOverridden(ElementContainer child, Mogram mogram) {
        for (Mogram c : child.components()) {
            if (this.isHasReference(c) || !this.areNamesake(mogram, c) || !Resolver.mainType(c).equals(Resolver.mainType(mogram))) continue;
            if (c instanceof MogramImpl && !c.parent().resolved()) {
                ((MogramImpl)c).parent(mogram);
            }
            return true;
        }
        return false;
    }

    private boolean isHasReference(Mogram component) {
        return component instanceof HasMogram && ((HasMogram)((Object)component)).isHas();
    }

    private boolean isOverridden(Mogram child, Property prop) {
        return child.properties().stream().anyMatch(ch -> ch.name().equals(prop.name()) && ch.type().equals(prop.type()));
    }

    private boolean areNamesake(Mogram mogram, Mogram c) {
        return c.name() != null && c.name().equals(mogram.name());
    }

    private List<Mogram> getChildrenSorted(Mogram parent) {
        ArrayList<Mogram> children = new ArrayList<Mogram>(parent.children());
        this.sort(children);
        return children;
    }

    private List<Mogram> sort(List<Mogram> mograms) {
        if (mograms.isEmpty()) {
            return mograms;
        }
        mograms.sort(this.inheritanceComparator());
        Collections.reverse(mograms);
        return mograms;
    }

    private Comparator<Mogram> inheritanceComparator() {
        return new Comparator<Mogram>(this){

            @Override
            public int compare(Mogram o1, Mogram o2) {
                return this.maxLevel(o1) - this.maxLevel(o2);
            }

            private int maxLevel(Mogram mogram) {
                ArrayList<Integer> levels = new ArrayList<Integer>(Collections.singletonList(0));
                levels.addAll(mogram.children().stream().map(this::maxLevel).toList());
                levels.sort(Collections.reverseOrder());
                return 1 + (Integer)levels.get(0);
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }

            public int hashCode() {
                return super.hashCode();
            }
        };
    }
}

